/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.DiscoveryBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.ItemModWindowSetup;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.ParticleBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.ResearchMissionBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.ResearchMission;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.functions.ResearchMissionRegistry;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.revelation_box.RevelationBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.WindowBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.window_box.WindowsInit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class MainBox {
    public static ParticleBox PARTICLE_BOX = new ParticleBox();
    public static ItemBox ITEM_BOX = new ItemBox();
    public static WindowBox WINDOW_BOX = new WindowBox();
    public static DiscoveryBox DISCOVERY_BOX = new DiscoveryBox();
    public static ResearchMissionBox RESEARCH_MISSION_BOX = new ResearchMissionBox();
    public static RevelationBox REVELATION_BOX = new RevelationBox();
    private static boolean isItemDataGenerated = false;

    public static void clearModData() {
        PARTICLE_BOX.clear();
        DISCOVERY_BOX.clear();
        RESEARCH_MISSION_BOX.clear();
        Qdc.DisassemblerVariables.discoveredItems.clear();
    }

    public static void setItemDiscovered(DiscoveryItem item) {
        DISCOVERY_BOX.addDiscoveredItem(item);
        ITEM_BOX.setDiscovered(item.item);
        RESEARCH_MISSION_BOX.updateDiscoveredMissionItem(item.item);
    }

    public static boolean isItemDiscovered(Item item) {
        return DISCOVERY_BOX.isItemDiscovered(item);
    }

    public static void registerNewMission(ResearchMission newResearchMission) {
        RESEARCH_MISSION_BOX.addNewMission(newResearchMission);
    }

    public static void loadModData(Player player) {
        MainBox.clearModData();
        PARTICLE_BOX.loadPlayerParticles(player);
        DISCOVERY_BOX.loadData(player);
        RESEARCH_MISSION_BOX.loadData(player);
        ITEM_BOX.loadData(player);
        if (!isItemDataGenerated) {
            WindowsInit.initWindowList();
            ItemModWindowSetup.initModItemList(Qdc.curPlayer.level());
            ResearchMissionRegistry.registerMissions();
            ITEM_BOX.sortItemCollections();
            isItemDataGenerated = true;
        }
        WINDOW_BOX.calcWindowDiscoveries();
        ITEM_BOX.setItemList();
    }

    public static void saveData(Player player) {
        PARTICLE_BOX.saveData(player);
        DISCOVERY_BOX.saveData(player);
        RESEARCH_MISSION_BOX.saveData(player);
        ITEM_BOX.saveData(player);
    }
}

