/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.AttachmentInit;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class DiscoveryBox {
    public List<DiscoveryItem> discoveryItemList = new ArrayList<DiscoveryItem>();
    public List<DiscoveryItem> temp_discoveryItemList = new ArrayList<DiscoveryItem>();
    public List<String> idList = new ArrayList<String>();
    public String discoveryIdString = "";
    public String itemCountString = "";

    public void clear() {
        this.discoveryIdString = "";
        this.itemCountString = "";
        this.discoveryItemList = new ArrayList<DiscoveryItem>();
        this.idList = new ArrayList<String>();
    }

    public int getItemCount(Item item) {
        int index = this.getIndexOfItem(item);
        if (index == -1) {
            return -1;
        }
        return this.discoveryItemList.get((int)index).count;
    }

    public int increaseItemCount(DiscoveryItem item) {
        int index = this.getIndexOfItem(item.item);
        if (index == -1) {
            GlobalFuncs.msg("index not found " + this.getNameForPlacement(item.item));
            return -2;
        }
        GlobalFuncs.msg("index is found " + this.getNameForPlacement(item.item));
        return this.discoveryItemList.get(index).addItems(item.count);
    }

    public int reduceItemCount(DiscoveryItem item) {
        int index = this.getIndexOfItem(item.item);
        if (index == -1) {
            return -1;
        }
        return this.discoveryItemList.get(index).removeItems(item.count);
    }

    public boolean isItemDiscovered(String name) {
        int index = this.getIndexOfItem(name);
        return index > -1;
    }

    public boolean isItemDiscovered(Item item) {
        return this.isItemDiscovered(this.getNameForPlacement(item));
    }

    public void addDiscoveredItem(DiscoveryItem item) {
        String itemName = this.getNameForPlacement(item.item);
        System.out.println(">>>>>>>>> " + itemName + " <<<<<<<<<<");
        this.discoveryItemList.add(item);
        this.idList.add(itemName);
        this.discoveryIdString = this.discoveryIdString + itemName + ",";
        this.itemCountString = this.itemCountString + item.count + ",";
    }

    private String getNameForPlacement(Item item) {
        return "" + Item.getId((Item)item);
    }

    private void extractFromStrings() {
        String[] id_parts = this.discoveryIdString.split(",");
        String[] count_parts = this.itemCountString.split(",");
        this.clear();
        DiscoveryItem tempDiscoveryItem = null;
        if (id_parts.length > count_parts.length) {
            for (int i = 0; i < id_parts.length; ++i) {
                tempDiscoveryItem = count_parts.length > i ? this.getDiscoveryItemsFromStrings(id_parts[i], count_parts[i]) : this.getDiscoveryItemsFromStrings(id_parts[i], "1");
                if (tempDiscoveryItem == null) continue;
                this.temp_discoveryItemList.add(new DiscoveryItem(tempDiscoveryItem.item, tempDiscoveryItem.count));
            }
        } else {
            for (int i = 0; i < id_parts.length; ++i) {
                tempDiscoveryItem = this.getDiscoveryItemsFromStrings(id_parts[i], count_parts[i]);
                if (tempDiscoveryItem == null) continue;
                this.temp_discoveryItemList.add(new DiscoveryItem(tempDiscoveryItem.item, tempDiscoveryItem.count));
            }
        }
    }

    private DiscoveryItem getDiscoveryItemsFromStrings(String itemName, String count) {
        if (itemName.isBlank()) {
            return null;
        }
        Item item = Item.byId((int)Integer.parseInt(itemName));
        int intCount = -1;
        intCount = count.isBlank() ? 1 : Integer.parseInt(count);
        return new DiscoveryItem(item, intCount);
    }

    public void parseIdListString() {
        this.extractFromStrings();
        for (DiscoveryItem di : this.temp_discoveryItemList) {
            if (this.isItemDiscovered(di.item)) continue;
            MainBox.setItemDiscovered(di);
        }
    }

    private int getIndexOfItem(Item item) {
        return this.getIndexOfItem(this.getNameForPlacement(item));
    }

    private int getIndexOfItem(String itemName) {
        return this.idList.indexOf(itemName);
    }

    private void reconstructStrings() {
        this.discoveryIdString = "";
        this.itemCountString = "";
        for (DiscoveryItem item : this.discoveryItemList) {
            this.discoveryIdString = this.discoveryIdString + this.getNameForPlacement(item.item) + ",";
            this.itemCountString = this.itemCountString + item.count + ",";
        }
    }

    public void loadData(Player player) {
        if (player.hasData(AttachmentInit.DISCOVERY_ITEM)) {
            this.discoveryIdString = (String)player.getData(AttachmentInit.DISCOVERY_ITEM);
        } else {
            player.setData(AttachmentInit.DISCOVERY_ITEM, (Object)"");
        }
        if (player.hasData(AttachmentInit.DISCOVERY_AMOUNT)) {
            this.itemCountString = (String)player.getData(AttachmentInit.DISCOVERY_AMOUNT);
        } else {
            player.setData(AttachmentInit.DISCOVERY_AMOUNT, (Object)"");
        }
        this.temp_discoveryItemList.clear();
        this.parseIdListString();
    }

    public void saveData(Player player) {
        this.reconstructStrings();
        player.setData(AttachmentInit.DISCOVERY_ITEM, (Object)this.discoveryIdString);
        player.setData(AttachmentInit.DISCOVERY_AMOUNT, (Object)this.itemCountString);
    }
}

