/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.disassembler.DisassemblerInventoryItem;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;

public class DisassemblerFunctions {
    public static void disassembleSingleItem(DisassemblerInventoryItem item) {
        DisassemblerFunctions.disassembleItem(item, 1);
    }

    public static void disassembleStack(DisassemblerInventoryItem item) {
        DisassemblerFunctions.disassembleItem(item, item.stack.getCount());
    }

    public static void disassembleAllStacks(DisassemblerInventoryItem item, List<DisassemblerInventoryItem> allItems) {
        for (DisassemblerInventoryItem invItem : allItems) {
            if (item.stack.getItem() != invItem.stack.getItem()) continue;
            DisassemblerFunctions.disassembleItem(invItem, invItem.stack.getCount());
        }
    }

    public static void disassembleItem(DisassemblerInventoryItem item, int count) {
        int actualIndex = item.actualIndex;
        Item curItem = item.stack.getItem();
        ParticleCollection particles = MainBox.ITEM_BOX.getItemParticles(item.stack);
        Qdc.curPlayer.getInventory().removeItem(actualIndex, count);
        int newCount = Qdc.curPlayer.getInventory().getItem(actualIndex).getCount();
        int itemID = Item.getId((Item)Qdc.curPlayer.getInventory().getItem(actualIndex).getItem());
        if (!MainBox.ITEM_BOX.shouldKeepMana(curItem)) {
            if (MainBox.ITEM_BOX.canItemBeDiscovered(curItem) && !MainBox.DISCOVERY_BOX.isItemDiscovered(curItem)) {
                MainBox.DISCOVERY_BOX.addDiscoveredItem(new DiscoveryItem(curItem, 0));
                Qdc.DisassemblerVariables.addNewDIscoveredItem(curItem);
                MainBox.ITEM_BOX.setDiscovered(curItem);
                MainBox.WINDOW_BOX.calcWindowDiscoveries();
            }
            QdcApi.QDC_CORE.FUNCTIONS.addParticles(particles, count, true);
        } else {
            QdcApi.QDC_CORE.FUNCTIONS.addParticles(particles, count, false);
        }
        MainBox.RESEARCH_MISSION_BOX.updateDiscoveredMissionItem(curItem);
        MainBox.DISCOVERY_BOX.increaseItemCount(new DiscoveryItem(curItem, count));
        MainBox.saveData(Qdc.curPlayer);
        PacketDistributor.sendToServer((CustomPacketPayload)new myData.MyData(actualIndex, itemID, newCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

