/*
 * Decompiled with CFR 0.152.
 */
package net.xndir.classiccombat;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;

@Mod(value="classiccombat")
public class ClassicCombat {
    public static final String MODID = "classiccombat";
    public static final String VERSION = "1.19.4";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Field ATTACK_STRENGTH_TICKER_FIELD = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"attackStrengthTicker");

    public ClassicCombat() {
        ATTACK_STRENGTH_TICKER_FIELD.setAccessible(true);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("\u001b[1;93mClassic Combat 1.19.4\u001b[0m");
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        Player player = playerTickEvent.player;
        if (playerTickEvent.side.isServer()) {
            try {
                if (ATTACK_STRENGTH_TICKER_FIELD.getInt(player) <= 0) {
                    ATTACK_STRENGTH_TICKER_FIELD.set(player, 100);
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Classic Combat failed to reset player attack strength");
                LOGGER.error(e.toString());
            }
        }
    }
}

