/*
 * Decompiled with CFR 0.152.
 */
package me.example.civiliztions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;

class Civilization {
    private String name;
    private String description;
    private Location spawnPoint;
    private int maxMembers;
    private UUID leaderId;
    private final Set<UUID> memberIds = new HashSet<UUID>();
    private final Map<UUID, String> memberRoles = new HashMap<UUID, String>();
    private double bankBalance;

    public Civilization(String name, String description, Location spawnPoint, int maxMembers, double startingBalance) {
        this.name = name;
        this.description = description;
        this.spawnPoint = spawnPoint;
        this.maxMembers = maxMembers;
        this.bankBalance = startingBalance;
    }

    public double getBankBalance() {
        return this.bankBalance;
    }

    public void deposit(double amount) {
        if (amount > 0.0) {
            this.bankBalance += amount;
        }
    }

    public boolean withdraw(double amount) {
        if (amount > 0.0 && this.bankBalance >= amount) {
            this.bankBalance -= amount;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public Location getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Location spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public int getMaxMembers() {
        return this.maxMembers;
    }

    public Set<UUID> getMemberIds() {
        return new HashSet<UUID>(this.memberIds);
    }

    public int getMemberCount() {
        return this.memberIds.size();
    }

    public UUID getLeaderId() {
        return this.leaderId;
    }

    public boolean isLeader(UUID uuid) {
        return this.leaderId != null && this.leaderId.equals(uuid);
    }

    public void addMember(UUID uuid, String role) {
        this.memberIds.add(uuid);
        this.memberRoles.put(uuid, role);
    }

    public void removeMember(UUID uuid) {
        this.memberIds.remove(uuid);
        this.memberRoles.remove(uuid);
        if (this.leaderId != null && this.leaderId.equals(uuid)) {
            this.leaderId = null;
        }
    }

    public void promoteToLeader(UUID uuid) {
        if (this.memberIds.contains(uuid)) {
            this.leaderId = uuid;
            this.memberRoles.put(uuid, "Leader");
        }
    }
}

