/*
 * Decompiled with CFR 0.152.
 */
package me.example.civiliztions;

import com.origins999.Data;
import com.origins999.Origin;
import com.origins999.Origins999;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.example.civiliztions.Civilization;
import me.example.civiliztions.CivilizationsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class CivilizationsGroupManager
implements Listener {
    private final CivilizationsPlugin plugin;
    private Origins999 origins999Plugin;
    private final Map<String, GroupData> groups = new HashMap<String, GroupData>();
    private final Map<String, Location> groupSpawns = new HashMap<String, Location>();
    private FileConfiguration groupsConfig;

    public CivilizationsGroupManager(CivilizationsPlugin plugin, Origins999 origins999Plugin) {
        this.plugin = plugin;
        this.origins999Plugin = origins999Plugin;
        this.groupsConfig = new YamlConfiguration();
        this.loadGroupsConfig();
    }

    private Logger getLogger() {
        return this.plugin.getLogger();
    }

    private FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    private void saveResource(String resourcePath, boolean replace) {
        this.plugin.saveResource(resourcePath, replace);
    }

    private File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    public void onEnable() {
        if (this.origins999Plugin != null) {
            this.plugin.getCommand("civilizations").setTabCompleter((TabCompleter)new GroupTabCompleter(this.plugin, this.origins999Plugin));
        }
    }

    public void onDisable() {
        this.saveGroupsConfig();
    }

    private void loadGroupsConfig() {
        File groupsFile = new File(this.getDataFolder(), "groups.yml");
        if (!groupsFile.exists()) {
            this.getLogger().info("groups.yml not found, creating default.");
            this.saveResource("groups.yml", false);
        }
        this.getLogger().info("Attempting to load groups from: " + groupsFile.getAbsolutePath());
        try {
            this.groupsConfig.load(groupsFile);
            this.getLogger().info("Successfully loaded groups.yml.");
            if (this.groupsConfig.contains("groups")) {
                ConfigurationSection groupsSection = this.groupsConfig.getConfigurationSection("groups");
                for (String groupName : groupsSection.getKeys(false)) {
                    Location spawn;
                    HashSet<UUID> members = new HashSet<UUID>();
                    for (String uuidStr : groupsSection.getStringList(groupName + ".members")) {
                        try {
                            members.add(UUID.fromString(uuidStr));
                        }
                        catch (IllegalArgumentException e) {
                            this.getLogger().warning("Invalid UUID in group " + groupName + ": " + uuidStr);
                        }
                    }
                    String originName = groupsSection.getString(groupName + ".origin", "");
                    this.groups.put(groupName.toLowerCase(), new GroupData(originName, members));
                    ConfigurationSection spawnSection = groupsSection.getConfigurationSection(groupName + ".spawn");
                    if (spawnSection == null || (spawn = this.loadLocation(spawnSection)) == null) continue;
                    this.groupSpawns.put(groupName.toLowerCase(), spawn);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Could not load groups.yml: " + e.getMessage());
        }
    }

    private void saveGroupsConfig() {
        File groupsFile = new File(this.getDataFolder(), "groups.yml");
        this.getLogger().info("Attempting to save groups to: " + groupsFile.getAbsolutePath());
        this.groupsConfig.set("groups", null);
        for (Map.Entry<String, GroupData> entry : this.groups.entrySet()) {
            ArrayList<String> uuidStrings = new ArrayList<String>();
            for (UUID uuid : entry.getValue().getMembers()) {
                uuidStrings.add(uuid.toString());
            }
            this.groupsConfig.set("groups." + entry.getKey() + ".members", uuidStrings);
            this.groupsConfig.set("groups." + entry.getKey() + ".origin", (Object)entry.getValue().getOriginName());
        }
        try {
            this.groupsConfig.save(groupsFile);
            this.getLogger().info("Successfully saved groups.yml.");
        }
        catch (Exception e) {
            this.getLogger().severe("Could not save groups.yml: " + e.getMessage());
        }
    }

    private Location loadLocation(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)section.getString("world", "world"));
        if (world == null) {
            return null;
        }
        return new Location(world, section.getDouble("x"), section.getDouble("y"), section.getDouble("z"), (float)section.getDouble("yaw", 0.0), (float)section.getDouble("pitch", 0.0));
    }

    public boolean handleCivilizationsGroupCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (this.origins999Plugin == null) {
            sender.sendMessage("\u00a7cThis feature is disabled because Origins999 is not installed.");
            return true;
        }
        if (!sender.hasPermission("civilizations.group") && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /civilizations group <create|setspawn|info> ...");
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "create": {
                if (args.length < 4) {
                    sender.sendMessage("\u00a7cUsage: /civilizations group create <origin_name> <group_name>");
                    return true;
                }
                String requestedOriginName = args[2];
                String groupName = args[3];
                if (this.origins999Plugin == null) {
                    sender.sendMessage("\u00a7cOrigins999 plugin not found or not enabled. Cannot create group.");
                    return true;
                }
                Origin origin = null;
                for (Origin o : this.origins999Plugin.getOrigins()) {
                    if (!o.getName().equalsIgnoreCase(requestedOriginName)) continue;
                    origin = o;
                    break;
                }
                if (origin == null) {
                    sender.sendMessage("\u00a7cOrigin '" + requestedOriginName + "' not found or supported.");
                    List availableOrigins = this.origins999Plugin.getOrigins().stream().map(Origin::getName).collect(Collectors.toList());
                    this.getLogger().info("Available Origins: " + String.join((CharSequence)", ", availableOrigins));
                    return true;
                }
                if (this.groups.containsKey(groupName.toLowerCase())) {
                    sender.sendMessage("\u00a7cA group with the name '" + groupName + "' already exists.");
                    return true;
                }
                HashSet<UUID> membersForGroup = new HashSet<UUID>();
                for (Map.Entry entry : this.origins999Plugin.getPlayerDataMap().entrySet()) {
                    Data.PlayerData playerData = (Data.PlayerData)entry.getValue();
                    if (!playerData.hasChosenOrigin() || !playerData.getOrigin().equalsIgnoreCase(origin.getName())) continue;
                    membersForGroup.add((UUID)entry.getKey());
                }
                if (membersForGroup.isEmpty()) {
                    sender.sendMessage("\u00a7cNo players found with the origin '" + origin.getName() + "' to form a group.");
                    return true;
                }
                this.groups.put(groupName.toLowerCase(), new GroupData(origin.getName(), membersForGroup));
                this.getLogger().info("Group '" + groupName.toLowerCase() + "' added to internal map.");
                this.saveGroupsConfig();
                sender.sendMessage("\u00a7aGroup '" + groupName + "' created successfully with players of origin '" + origin.getName() + "'.");
                sender.sendMessage("\u00a7aMembers: " + membersForGroup.size());
                return true;
            }
            case "setspawn": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cOnly players can use this command!");
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /civilizations group setspawn <group_name>");
                    return true;
                }
                Player player = (Player)sender;
                String groupName = args[2];
                if (!this.groups.containsKey(groupName.toLowerCase())) {
                    sender.sendMessage("\u00a7cGroup '" + groupName + "' not found.");
                    return true;
                }
                if (!this.groups.get(groupName.toLowerCase()).contains(player.getUniqueId())) {
                    sender.sendMessage("\u00a7cYou are not a member of group '" + groupName + "'.");
                    return true;
                }
                this.groupSpawns.put(groupName.toLowerCase(), player.getLocation());
                this.saveGroupsConfig();
                sender.sendMessage("\u00a7aSpawn point for group '" + groupName + "' set to your current location.");
                return true;
            }
            case "info": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /civilizations group info <group_name>");
                    return true;
                }
                String groupName = args[2];
                GroupData groupData = this.groups.get(groupName.toLowerCase());
                if (groupData == null) {
                    sender.sendMessage("\u00a7cGroup '" + groupName + "' not found.");
                    return true;
                }
                sender.sendMessage("\u00a76\u00a7lGroup: \u00a7e" + groupName);
                sender.sendMessage("\u00a76Origin: \u00a7f" + groupData.getOriginName());
                sender.sendMessage("\u00a76Members: \u00a7f" + groupData.getMembers().size());
                Location spawnLocation = this.groupSpawns.get(groupName.toLowerCase());
                if (spawnLocation != null) {
                    sender.sendMessage("\u00a76Spawn: \u00a7f" + String.format("%s, %.1f, %.1f, %.1f", spawnLocation.getWorld().getName(), spawnLocation.getX(), spawnLocation.getY(), spawnLocation.getZ()));
                } else {
                    sender.sendMessage("\u00a76Spawn: \u00a7fNot set");
                }
                return true;
            }
        }
        sender.sendMessage("\u00a7cUsage: /civilizations group <create|setspawn|info> ...");
        return true;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Civilization civ;
        String civName;
        Data.PlayerData playerData;
        Player player = event.getPlayer();
        if (this.origins999Plugin != null && (playerData = (Data.PlayerData)this.origins999Plugin.getPlayerDataMap().get(player.getUniqueId())) != null && playerData.hasChosenOrigin()) {
            String playerOriginName = playerData.getOrigin();
            for (Map.Entry<String, GroupData> entry : this.groups.entrySet()) {
                Location spawnLocation;
                String groupName = entry.getKey();
                GroupData groupData = entry.getValue();
                if (!groupData.getOriginName().equalsIgnoreCase(playerOriginName) || (spawnLocation = this.groupSpawns.get(groupName)) == null) continue;
                event.setRespawnLocation(spawnLocation);
                player.sendMessage("\u00a7aTeleported to your group's spawn point: \u00a7e" + groupName);
                return;
            }
        }
        if ((civName = this.plugin.playerCivilizations.get(event.getPlayer().getUniqueId())) != null && (civ = this.plugin.civilizations.get(civName)) != null && civ.getSpawnPoint() != null) {
            event.setRespawnLocation(civ.getSpawnPoint());
            return;
        }
        if (this.plugin.defaultSpawn != null) {
            event.setRespawnLocation(this.plugin.defaultSpawn);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.origins999Plugin == null) {
            this.getLogger().warning("Origins999 plugin not found. Cannot handle origin-based group spawns or assignments.");
            return;
        }
        Data.PlayerData playerData = (Data.PlayerData)this.origins999Plugin.getPlayerDataMap().get(player.getUniqueId());
        if (playerData != null && playerData.hasChosenOrigin()) {
            String playerOriginName = playerData.getOrigin();
            for (Map.Entry<String, GroupData> entry : this.groups.entrySet()) {
                Location spawnLocation;
                String groupName = entry.getKey();
                GroupData groupData = entry.getValue();
                if (!groupData.getOriginName().equalsIgnoreCase(playerOriginName)) continue;
                if (!groupData.contains(player.getUniqueId())) {
                    groupData.getMembers().add(player.getUniqueId());
                    this.getLogger().info("Player " + player.getName() + " with origin " + playerOriginName + " automatically added to group " + groupName);
                    player.sendMessage("\u00a7aYou have been automatically added to group '" + groupName + "' based on your origin!");
                    this.saveGroupsConfig();
                }
                if ((spawnLocation = this.groupSpawns.get(groupName)) == null) continue;
                player.teleport(spawnLocation);
                player.sendMessage("\u00a7aTeleported to your group's spawn point: \u00a7e" + groupName);
                return;
            }
        }
    }

    public boolean isFriendlyFireGroup(Player attacker, Player victim) {
        if (!this.getConfig().getBoolean("groups.friendly-fire", false)) {
            for (GroupData groupMembers : this.groups.values()) {
                if (!groupMembers.contains(attacker.getUniqueId()) || !groupMembers.contains(victim.getUniqueId())) continue;
                attacker.sendMessage("\u00a7cYou can't hurt members of your group!");
                return true;
            }
        }
        return false;
    }

    public Map<String, GroupData> getGroups() {
        return this.groups;
    }

    public static class GroupData {
        private final String originName;
        private final Set<UUID> members;

        public GroupData(String originName, Set<UUID> members) {
            this.originName = originName;
            this.members = members;
        }

        public boolean contains(UUID uniqueId) {
            return this.members.contains(uniqueId);
        }

        public String getOriginName() {
            return this.originName;
        }

        public Set<UUID> getMembers() {
            return this.members;
        }
    }

    class GroupTabCompleter
    implements TabCompleter {
        private final CivilizationsPlugin plugin;
        private final Origins999 origins999Plugin;

        public GroupTabCompleter(CivilizationsPlugin plugin, Origins999 origins999Plugin) {
            this.plugin = plugin;
            this.origins999Plugin = origins999Plugin;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if ((command.getName().equalsIgnoreCase("civilizations") || command.getName().equalsIgnoreCase("civ")) && args.length > 0 && args[0].equalsIgnoreCase("group")) {
                if (args.length == 2) {
                    return Arrays.asList("create", "setspawn", "info").stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
                if (args.length == 3) {
                    String groupSubCommand = args[1].toLowerCase();
                    if (groupSubCommand.equals("create")) {
                        return this.origins999Plugin.getOrigins().stream().map(Origin::getName).filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                    }
                    if (groupSubCommand.equals("setspawn") || groupSubCommand.equals("info")) {
                        return CivilizationsGroupManager.this.getGroups().keySet().stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                    }
                } else if (args.length == 4 && args[1].equalsIgnoreCase("create")) {
                    return Collections.emptyList();
                }
            }
            return Collections.emptyList();
        }
    }
}

