/*
 * Decompiled with CFR 0.152.
 */
package me.example.civiliztions;

import com.origins999.Origins999;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.example.civiliztions.Civilization;
import me.example.civiliztions.CivilizationsGroupManager;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CivilizationsPlugin
extends JavaPlugin
implements Listener {
    public final Map<String, Civilization> civilizations = new HashMap<String, Civilization>();
    public final Map<UUID, String> playerCivilizations = new HashMap<UUID, String>();
    private final Map<UUID, String> pendingInvites = new HashMap<UUID, String>();
    private final Map<UUID, Boolean> chatVisibility = new HashMap<UUID, Boolean>();
    private final Map<String, Set<Chunk>> claimedChunks = new HashMap<String, Set<Chunk>>();
    public final Map<String, Set<String>> allianceInvites = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> alliances = new HashMap<String, Set<String>>();
    private CivilizationsGroupManager groupManager;
    private int maxMembersPerCivilization;
    public Location defaultSpawn;
    private Economy econ = null;
    private boolean vaultEnabled = false;

    public void onEnable() {
        long interval;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        if (!this.setupEconomy()) {
            this.getLogger().info("Vault not found, economy features will be disabled.");
            this.vaultEnabled = false;
        } else {
            this.vaultEnabled = true;
            this.getLogger().info("Vault found, economy features enabled.");
        }
        this.loadConfiguration();
        this.getLogger().info("Civilizations plugin has been enabled!");
        Origins999 origins999Plugin = null;
        if (Bukkit.getPluginManager().getPlugin("Origins999") != null) {
            origins999Plugin = (Origins999)Bukkit.getPluginManager().getPlugin("Origins999");
            this.getLogger().info("Origins999 plugin found, group features enabled.");
        } else {
            this.getLogger().warning("Origins999 plugin not found! Group features will be disabled.");
        }
        this.groupManager = new CivilizationsGroupManager(this, origins999Plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.groupManager, (Plugin)this);
        this.groupManager.onEnable();
        if (this.vaultEnabled && this.getConfig().getBoolean("economy.upkeep.enabled", true) && (interval = this.getConfig().getLong("economy.upkeep.interval-hours", 24L) * 60L * 60L * 20L) > 0L) {
            new UpkeepTask(this).runTaskTimerAsynchronously((Plugin)this, interval, interval);
            this.getLogger().info("Upkeep task scheduled to run every " + this.getConfig().getLong("economy.upkeep.interval-hours", 24L) + " hours.");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public void onDisable() {
        this.groupManager.onDisable();
        this.saveConfiguration();
        this.getLogger().info("Civilizations plugin has been disabled!");
    }

    private void loadConfiguration() {
        ConfigurationSection allianceInvitesSection;
        ConfigurationSection alliancesSection;
        ConfigurationSection claimsSection;
        FileConfiguration config = this.getConfig();
        this.maxMembersPerCivilization = config.getInt("max-members-per-civilization", 10);
        ConfigurationSection defaultSpawnSection = config.getConfigurationSection("default-spawn");
        this.defaultSpawn = defaultSpawnSection != null ? this.loadLocation(defaultSpawnSection) : ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
        ConfigurationSection civsSection = config.getConfigurationSection("civilizations");
        if (civsSection != null) {
            for (String civKey : civsSection.getKeys(false)) {
                ConfigurationSection civSection = civsSection.getConfigurationSection(civKey);
                double bankBalance = civSection.getDouble("bankBalance", this.getConfig().getDouble("economy.starting-balance", 0.0));
                Civilization civ = new Civilization(civSection.getString("name", civKey), civSection.getString("description", ""), this.loadLocation(civSection.getConfigurationSection("spawn")), civSection.getInt("max-members", this.maxMembersPerCivilization), bankBalance);
                List memberUUIDs = civSection.getStringList("members");
                for (String uuidStr : memberUUIDs) {
                    try {
                        UUID uuid = UUID.fromString(uuidStr);
                        this.playerCivilizations.put(uuid, civKey.toLowerCase());
                        civ.addMember(uuid, "Member");
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Invalid UUID format in members list for civilization " + civKey);
                    }
                }
                String leaderStr = civSection.getString("leader");
                if (leaderStr != null) {
                    try {
                        UUID leaderUUID = UUID.fromString(leaderStr);
                        civ.promoteToLeader(leaderUUID);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Invalid UUID format for leader in civilization " + civKey);
                    }
                } else if (!civ.getMemberIds().isEmpty()) {
                    UUID firstMember = civ.getMemberIds().iterator().next();
                    civ.promoteToLeader(firstMember);
                }
                this.civilizations.put(civKey.toLowerCase(), civ);
            }
        }
        if ((claimsSection = config.getConfigurationSection("claimed-chunks")) != null) {
            for (String civKey : claimsSection.getKeys(false)) {
                HashSet<Chunk> chunks = new HashSet<Chunk>();
                ConfigurationSection civClaims = claimsSection.getConfigurationSection(civKey);
                for (String chunkKey : civClaims.getKeys(false)) {
                    int z;
                    int x;
                    String[] parts = chunkKey.split(",");
                    if (parts.length != 3) continue;
                    String worldName = parts[0];
                    try {
                        x = Integer.parseInt(parts[1]);
                        z = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        this.getLogger().warning("Invalid chunk coordinates in claimed chunks for " + civKey);
                        continue;
                    }
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) continue;
                    chunks.add(world.getChunkAt(x, z));
                }
                this.claimedChunks.put(civKey.toLowerCase(), chunks);
            }
        }
        if ((alliancesSection = config.getConfigurationSection("alliances")) != null) {
            for (String civKey : alliancesSection.getKeys(false)) {
                List alliedList = alliancesSection.getStringList(civKey);
                this.alliances.put(civKey.toLowerCase(), new HashSet(alliedList));
            }
        }
        if ((allianceInvitesSection = config.getConfigurationSection("alliance-invites")) != null) {
            for (String civKey : allianceInvitesSection.getKeys(false)) {
                List invitesList = allianceInvitesSection.getStringList(civKey);
                this.allianceInvites.put(civKey.toLowerCase(), new HashSet(invitesList));
            }
        }
    }

    private Location loadLocation(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)section.getString("world", "world"));
        if (world == null) {
            return null;
        }
        return new Location(world, section.getDouble("x"), section.getDouble("y"), section.getDouble("z"), (float)section.getDouble("yaw", 0.0), (float)section.getDouble("pitch", 0.0));
    }

    private void saveConfiguration() {
        FileConfiguration config = this.getConfig();
        config.set("max-members-per-civilization", (Object)this.maxMembersPerCivilization);
        if (this.defaultSpawn != null) {
            config.set("default-spawn.world", (Object)this.defaultSpawn.getWorld().getName());
            config.set("default-spawn.x", (Object)this.defaultSpawn.getX());
            config.set("default-spawn.y", (Object)this.defaultSpawn.getY());
            config.set("default-spawn.z", (Object)this.defaultSpawn.getZ());
            config.set("default-spawn.yaw", (Object)Float.valueOf(this.defaultSpawn.getYaw()));
            config.set("default-spawn.pitch", (Object)Float.valueOf(this.defaultSpawn.getPitch()));
        }
        config.set("civilizations", null);
        for (Map.Entry<String, Civilization> entry : this.civilizations.entrySet()) {
            String key = entry.getKey();
            Civilization civ = entry.getValue();
            config.set("civilizations." + key + ".name", (Object)civ.getName());
            config.set("civilizations." + key + ".description", (Object)civ.getDescription());
            if (civ.getSpawnPoint() != null) {
                Location spawn = civ.getSpawnPoint();
                config.set("civilizations." + key + ".spawn.world", (Object)spawn.getWorld().getName());
                config.set("civilizations." + key + ".spawn.x", (Object)spawn.getX());
                config.set("civilizations." + key + ".spawn.y", (Object)spawn.getY());
                config.set("civilizations." + key + ".spawn.z", (Object)spawn.getZ());
                config.set("civilizations." + key + ".spawn.yaw", (Object)Float.valueOf(spawn.getYaw()));
                config.set("civilizations." + key + ".spawn.pitch", (Object)Float.valueOf(spawn.getPitch()));
            }
            config.set("civilizations." + key + ".max-members", (Object)civ.getMaxMembers());
            config.set("civilizations." + key + ".bankBalance", (Object)civ.getBankBalance());
            ArrayList<String> memberUUIDs = new ArrayList<String>();
            for (UUID memberId : civ.getMemberIds()) {
                memberUUIDs.add(memberId.toString());
            }
            config.set("civilizations." + key + ".members", memberUUIDs);
            if (civ.getLeaderId() == null) continue;
            config.set("civilizations." + key + ".leader", (Object)civ.getLeaderId().toString());
        }
        config.set("claimed-chunks", null);
        for (Map.Entry<String, Object> entry : this.claimedChunks.entrySet()) {
            String civKey = entry.getKey();
            Set chunks = (Set)entry.getValue();
            ConfigurationSection civClaims = config.createSection("claimed-chunks." + civKey);
            for (Chunk chunk : chunks) {
                String chunkKey = chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
                civClaims.set(chunkKey, (Object)true);
            }
        }
        config.set("alliances", null);
        for (Map.Entry<String, Object> entry : this.alliances.entrySet()) {
            config.set("alliances." + entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        config.set("alliance-invites", null);
        for (Map.Entry<String, Object> entry : this.allianceInvites.entrySet()) {
            config.set("alliance-invites." + entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        this.saveConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block67: {
            String subCommand;
            if (!command.getName().equalsIgnoreCase("civilizations") && !command.getName().equalsIgnoreCase("civ") && !command.getName().equalsIgnoreCase("civilizations999")) break block67;
            if (args.length == 0) {
                this.sendHelp(sender);
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "create": {
                    return this.handleCreateCommand(sender, args);
                }
                case "choose": 
                case "chose": {
                    return this.handleChoseCommand(sender, args);
                }
                case "setspawn": {
                    return this.handleSetSpawnCommand(sender, args);
                }
                case "info": {
                    return this.handleInfoCommand(sender, args);
                }
                case "invite": {
                    return this.handleInviteCommand(sender, args);
                }
                case "join": {
                    return this.handleJoinCommand(sender, args);
                }
                case "leave": {
                    return this.handleLeaveCommand(sender);
                }
                case "spawn": {
                    return this.handleSpawnCommand(sender);
                }
                case "myciv": {
                    return this.handleMyCivilizationCommand(sender);
                }
                case "rename": {
                    return this.handleRenameCommand(sender, args);
                }
                case "kick": {
                    return this.handleKickCommand(sender, args);
                }
                case "chat": {
                    return this.handleChatCommand(sender);
                }
                case "disband": {
                    return this.handleDisbandCommand(sender);
                }
                case "config": {
                    return this.handleConfigCommand(sender, args);
                }
                case "claim": {
                    return this.handleClaimCommand(sender);
                }
                case "unclaim": {
                    return this.handleUnclaimCommand(sender);
                }
                case "ally": {
                    return this.handleAllyCommand(sender, args);
                }
                case "unally": {
                    return this.handleUnallyCommand(sender, args);
                }
                case "bank": {
                    return this.handleBankCommand(sender, args);
                }
                case "group": {
                    return this.groupManager.handleCivilizationsGroupCommand(sender, args);
                }
            }
            this.sendHelp(sender);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleBankCommand(CommandSender sender, String[] args) {
        String action;
        if (!this.vaultEnabled) {
            sender.sendMessage("\u00a7cEconomy features are disabled because Vault is not installed.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /civ bank <balance|deposit|withdraw> [amount]");
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "balance": {
                player.sendMessage(String.format("\u00a76Your civilization's bank balance is: \u00a7a%.2f", civ.getBankBalance()));
                return true;
            }
            case "deposit": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /civ bank deposit <amount>");
                    return true;
                }
                try {
                    double amount = Double.parseDouble(args[2]);
                    if (amount <= 0.0) {
                        player.sendMessage("\u00a7cThe amount must be positive.");
                        return true;
                    }
                    if (this.econ.getBalance((OfflinePlayer)player) < amount) {
                        player.sendMessage("\u00a7cYou don't have enough money.");
                        return true;
                    }
                    EconomyResponse r = this.econ.withdrawPlayer((OfflinePlayer)player, amount);
                    if (r.transactionSuccess()) {
                        civ.deposit(amount);
                        player.sendMessage(String.format("\u00a7aYou have deposited %.2f into the civilization bank.", amount));
                        this.saveConfiguration();
                        return true;
                    }
                    player.sendMessage(String.format("\u00a7cAn error occurred: %s", r.errorMessage));
                    return true;
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid amount.");
                }
                return true;
            }
            case "withdraw": {
                if (!civ.isLeader(player.getUniqueId())) {
                    player.sendMessage("\u00a7cOnly the leader can withdraw from the civilization bank.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /civ bank withdraw <amount>");
                    return true;
                }
                try {
                    double amount = Double.parseDouble(args[2]);
                    if (amount <= 0.0) {
                        player.sendMessage("\u00a7cThe amount must be positive.");
                        return true;
                    }
                    if (civ.getBankBalance() < amount) {
                        player.sendMessage("\u00a7cThe civilization bank does not have enough money.");
                        return true;
                    }
                    if (!civ.withdraw(amount)) return true;
                    EconomyResponse r = this.econ.depositPlayer((OfflinePlayer)player, amount);
                    if (r.transactionSuccess()) {
                        player.sendMessage(String.format("\u00a7aYou have withdrawn %.2f from the civilization bank.", amount));
                        this.saveConfiguration();
                        return true;
                    }
                    player.sendMessage(String.format("\u00a7cAn error occurred: %s", r.errorMessage));
                    civ.deposit(amount);
                    return true;
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid amount.");
                }
                return true;
            }
        }
        player.sendMessage("\u00a7cUsage: /civ bank <balance|deposit|withdraw> [amount]");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7lCivilizations Commands:");
        sender.sendMessage("\u00a7e/civ create <name> [description] \u00a7f- Create a new civilization");
        sender.sendMessage("\u00a7e/civ chose <player> <civilization> \u00a7f- Assign a civilization to a player");
        sender.sendMessage("\u00a7e/civ setspawn <civilization> \u00a7f- Set spawn point for a civilization");
        sender.sendMessage("\u00a7e/civ info [civilization] \u00a7f- View civilization information");
        sender.sendMessage("\u00a7e/civ invite <player> \u00a7f- Invite a player to your civilization");
        sender.sendMessage("\u00a7e/civ join \u00a7f- Accept a pending civilization invitation");
        sender.sendMessage("\u00a7e/civ leave \u00a7f- Leave your current civilization");
        sender.sendMessage("\u00a7e/civ spawn \u00a7f- Teleport to your civilization's spawn");
        sender.sendMessage("\u00a7e/civ myciv \u00a7f- View your civilization's members and leader");
        sender.sendMessage("\u00a7e/civ rename <newname> \u00a7f- Rename your civilization (leader only)");
        sender.sendMessage("\u00a7e/civ kick <player> \u00a7f- Kick a player from your civilization (leader only)");
        sender.sendMessage("\u00a7e/civ chat \u00a7f- Toggle chat visibility for your civilization");
        sender.sendMessage("\u00a7e/civ disband \u00a7f- Disband your civilization (leader only)");
        sender.sendMessage("\u00a7e/civ config reload \u00a7f- Reload the configuration (OP only)");
        sender.sendMessage("\u00a7e/civ claim \u00a7f- Claim the chunk you are standing in for your civilization");
        sender.sendMessage("\u00a7e/civ unclaim \u00a7f- Unclaim the chunk you are standing in");
        sender.sendMessage("\u00a7e/civ ally <civilization> \u00a7f- Send alliance invite (leader only)");
        sender.sendMessage("\u00a7e/civ unally <civilization> \u00a7f- Remove alliance (leader only)");
        sender.sendMessage("\u00a7e/civ bank balance \u00a7f- Check your civilization's bank balance");
        sender.sendMessage("\u00a7e/civ bank deposit <amount> \u00a7f- Deposit money into your civilization's bank");
        sender.sendMessage("\u00a7e/civ bank withdraw <amount> \u00a7f- Withdraw money from your civilization's bank (leader only)");
        sender.sendMessage("\u00a7e/civ group create <origin_name> <group_name> \u00a7f- Create a new group based on origin");
        sender.sendMessage("\u00a7e/civ group setspawn <group_name> \u00a7f- Set spawn point for a group");
        sender.sendMessage("\u00a7e/civ group info <group_name> \u00a7f- View group information");
    }

    private boolean handleCreateCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("civilizations.create") && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /civilizations create <name> [description]");
            return true;
        }
        String name = args[1];
        if (this.civilizations.containsKey(name.toLowerCase())) {
            sender.sendMessage("\u00a7cA civilization with that name already exists!");
            return true;
        }
        String description = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "";
        double startingBalance = this.getConfig().getDouble("economy.starting-balance", 0.0);
        Civilization civ = new Civilization(name, description, null, this.maxMembersPerCivilization, startingBalance);
        this.civilizations.put(name.toLowerCase(), civ);
        sender.sendMessage("\u00a7aCivilization " + name + " has been created!");
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.playerCivilizations.put(player.getUniqueId(), name.toLowerCase());
            civ.addMember(player.getUniqueId(), "Leader");
            civ.promoteToLeader(player.getUniqueId());
            player.sendMessage("\u00a7aYou have been automatically added as leader to your new civilization!");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleChoseCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("civilizations.choose") && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /civilizations chose <player> <civilization>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        String civilizationName = args[2].toLowerCase();
        if (!this.civilizations.containsKey(civilizationName)) {
            sender.sendMessage("\u00a7cCivilization not found!");
            return true;
        }
        Civilization civ = this.civilizations.get(civilizationName);
        int memberCount = (int)this.playerCivilizations.entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(civilizationName)).count();
        if (civ.getMaxMembers() > 0 && memberCount >= civ.getMaxMembers()) {
            sender.sendMessage("\u00a7cThis civilization has reached its maximum member limit (" + civ.getMaxMembers() + ")!");
            return true;
        }
        this.playerCivilizations.put(target.getUniqueId(), civilizationName);
        civ.addMember(target.getUniqueId(), "Member");
        sender.sendMessage("\u00a7aPlayer " + target.getName() + " has been assigned to civilization " + civ.getName());
        target.sendMessage("\u00a7aYou have been assigned to civilization " + civ.getName());
        this.saveConfiguration();
        return true;
    }

    private boolean handleSetSpawnCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        if (!sender.hasPermission("civilizations.setspawn") && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /civilizations setspawn <civilization>");
            return true;
        }
        Player player = (Player)sender;
        String civilizationName = args[1].toLowerCase();
        if (!this.civilizations.containsKey(civilizationName)) {
            sender.sendMessage("\u00a7cCivilization not found!");
            return true;
        }
        String playerCiv = this.playerCivilizations.get(player.getUniqueId());
        if (playerCiv == null || !playerCiv.equalsIgnoreCase(civilizationName)) {
            sender.sendMessage("\u00a7cYou must be a member of this civilization to set its spawn!");
            return true;
        }
        Civilization civ = this.civilizations.get(civilizationName);
        if (!civ.isLeader(player.getUniqueId())) {
            sender.sendMessage("\u00a7cOnly the leader can set the spawn point!");
            return true;
        }
        civ.setSpawnPoint(player.getLocation());
        sender.sendMessage("\u00a7aSpawn point for " + civ.getName() + " has been set at your current location!");
        this.saveConfiguration();
        return true;
    }

    private boolean handleInfoCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("civilizations.info") && !(sender instanceof Player)) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 1) {
            if (this.civilizations.isEmpty()) {
                sender.sendMessage("\u00a7cNo civilizations have been created yet!");
                return true;
            }
            sender.sendMessage("\u00a76\u00a7lAvailable Civilizations:");
            for (Civilization civ : this.civilizations.values()) {
                int memberCount = (int)this.playerCivilizations.values().stream().filter(civName -> civName.equalsIgnoreCase(civ.getName().toLowerCase())).count();
                String membersInfo = civ.getMaxMembers() > 0 ? memberCount + "/" + civ.getMaxMembers() : memberCount + " members (no limit)";
                sender.sendMessage(String.format("\u00a7e- %s \u00a77(%s) \u00a7f- %s", civ.getName(), membersInfo, civ.getDescription()));
            }
            return true;
        }
        String civilizationName = args[1].toLowerCase();
        if (!this.civilizations.containsKey(civilizationName)) {
            sender.sendMessage("\u00a7cCivilization not found!");
            return true;
        }
        Civilization civ = this.civilizations.get(civilizationName);
        sender.sendMessage("\u00a76\u00a7lCivilization: \u00a7e" + civ.getName());
        sender.sendMessage("\u00a76Description: \u00a7f" + civ.getDescription());
        int memberCount = (int)this.playerCivilizations.values().stream().filter(civName -> civName.equalsIgnoreCase(civilizationName)).count();
        sender.sendMessage("\u00a76Members: \u00a7f" + memberCount + (String)(civ.getMaxMembers() > 0 ? "\u00a77/" + civ.getMaxMembers() : "\u00a77 (no limit)"));
        if (civ.getSpawnPoint() != null) {
            Location spawn = civ.getSpawnPoint();
            sender.sendMessage("\u00a76Spawn: \u00a7f" + String.format("%s, %.1f, %.1f, %.1f", spawn.getWorld().getName(), spawn.getX(), spawn.getY(), spawn.getZ()));
        } else {
            sender.sendMessage("\u00a76Spawn: \u00a7fNot set");
        }
        Set alliedCivs = this.alliances.getOrDefault(civilizationName, Collections.emptySet());
        if (alliedCivs.isEmpty()) {
            sender.sendMessage("\u00a76Alliances: \u00a7fNone");
        } else {
            sender.sendMessage("\u00a76Alliances: \u00a7f" + String.join((CharSequence)", ", alliedCivs));
        }
        return true;
    }

    private boolean handleInviteCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String senderCivName = this.playerCivilizations.get(player.getUniqueId());
        if (senderCivName == null) {
            sender.sendMessage("\u00a7cYou must be in a civilization to invite players!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /civilizations invite <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        if (this.playerCivilizations.containsKey(target.getUniqueId())) {
            sender.sendMessage("\u00a7c" + target.getName() + " is already in a civilization!");
            return true;
        }
        Civilization senderCiv = this.civilizations.get(senderCivName);
        int memberCount = (int)this.playerCivilizations.entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(senderCivName)).count();
        if (senderCiv.getMaxMembers() > 0 && memberCount >= senderCiv.getMaxMembers()) {
            sender.sendMessage("\u00a7cYour civilization has reached its maximum member limit (" + senderCiv.getMaxMembers() + ")!");
            return true;
        }
        this.pendingInvites.put(target.getUniqueId(), senderCivName);
        sender.sendMessage("\u00a7aYou have invited " + target.getName() + " to join " + senderCiv.getName());
        target.sendMessage("\u00a76\u00a7lYou have been invited to join " + senderCiv.getName() + "\u00a76!");
        target.sendMessage("\u00a7eUse \u00a7a/civilizations join \u00a7eto accept this invitation");
        target.sendMessage("\u00a77This invitation will expire when you log out");
        return true;
    }

    private boolean handleJoinCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (this.playerCivilizations.containsKey(player.getUniqueId())) {
            sender.sendMessage("\u00a7cYou are already in a civilization!");
            return true;
        }
        String invitedToCiv = this.pendingInvites.get(player.getUniqueId());
        if (invitedToCiv == null) {
            sender.sendMessage("\u00a7cYou don't have any pending civilization invitations!");
            return true;
        }
        Civilization civ = this.civilizations.get(invitedToCiv);
        int memberCount = (int)this.playerCivilizations.entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(invitedToCiv)).count();
        if (civ.getMaxMembers() > 0 && memberCount >= civ.getMaxMembers()) {
            sender.sendMessage("\u00a7cThe civilization you were invited to has reached its maximum member limit!");
            this.pendingInvites.remove(player.getUniqueId());
            return true;
        }
        this.playerCivilizations.put(player.getUniqueId(), invitedToCiv);
        civ.addMember(player.getUniqueId(), "Member");
        sender.sendMessage("\u00a7aYou have joined civilization " + civ.getName());
        this.pendingInvites.remove(player.getUniqueId());
        for (UUID memberId : civ.getMemberIds()) {
            Player member;
            if (memberId.equals(player.getUniqueId()) || (member = Bukkit.getPlayer((UUID)memberId)) == null) continue;
            member.sendMessage("\u00a76" + player.getName() + " has joined your civilization.");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleLeaveCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou can't leave your civilization as the leader! Use /civilizations disband instead.");
            return true;
        }
        this.playerCivilizations.remove(player.getUniqueId());
        civ.removeMember(player.getUniqueId());
        player.sendMessage("\u00a7aYou have left " + civ.getName());
        for (UUID memberId : civ.getMemberIds()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.equals(player)) continue;
            member.sendMessage("\u00a76" + player.getName() + " has left your civilization.");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleSpawnCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        Location spawn = civ.getSpawnPoint();
        if (spawn == null) {
            player.sendMessage("\u00a7cYour civilization hasn't set a spawn point yet!");
            return true;
        }
        player.teleport(spawn);
        player.sendMessage("\u00a7aTeleported to your civilization's spawn point!");
        return true;
    }

    private boolean handleMyCivilizationCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)("\u00a76" + civ.getName()));
        ItemStack leaderHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta leaderMeta = leaderHead.getItemMeta();
        UUID leaderId = civ.getLeaderId();
        OfflinePlayer leader = leaderId != null ? Bukkit.getOfflinePlayer((UUID)leaderId) : null;
        leaderMeta.setDisplayName("\u00a76" + civ.getName());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Members: \u00a7f" + civ.getMemberCount());
        lore.add("\u00a77Leader: \u00a7f" + (leader != null ? leader.getName() : "Unknown"));
        lore.add(" ");
        lore.add("\u00a7eClick to view members");
        lore.add("\u00a7eRight-click to view alliances");
        leaderMeta.setLore(lore);
        leaderHead.setItemMeta(leaderMeta);
        gui.setItem(13, leaderHead);
        player.openInventory(gui);
        return true;
    }

    private boolean handleClaimCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou must be in a civilization to claim chunks!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        Set civClaims = this.claimedChunks.getOrDefault(civName, new HashSet());
        int maxClaims = civ.getMemberCount();
        if (civClaims.size() >= maxClaims) {
            player.sendMessage("\u00a7cYour civilization has reached the maximum number of claimed chunks (" + maxClaims + ")!");
            return true;
        }
        Chunk chunk = player.getLocation().getChunk();
        for (Set<Chunk> chunks : this.claimedChunks.values()) {
            if (!chunks.contains(chunk)) continue;
            player.sendMessage("\u00a7cThis chunk is already claimed by another civilization!");
            return true;
        }
        civClaims.add(chunk);
        this.claimedChunks.put(civName, civClaims);
        player.sendMessage("\u00a7aChunk claimed for your civilization!");
        this.saveConfiguration();
        return true;
    }

    private boolean handleUnclaimCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou must be in a civilization to unclaim chunks!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        Chunk chunk = player.getLocation().getChunk();
        Set civClaims = this.claimedChunks.getOrDefault(civName, new HashSet());
        if (!civClaims.contains(chunk)) {
            player.sendMessage("\u00a7cThis chunk is not claimed by your civilization!");
            return true;
        }
        civClaims.remove(chunk);
        if (civClaims.isEmpty()) {
            this.claimedChunks.remove(civName);
        } else {
            this.claimedChunks.put(civName, civClaims);
        }
        player.sendMessage("\u00a7aChunk unclaimed for your civilization!");
        this.saveConfiguration();
        return true;
    }

    private boolean handleAllyCommand(CommandSender sender, String[] args) {
        Player targetLeader;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou must be in a civilization to manage alliances!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (!civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the leader can manage alliances!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /civilizations ally <civilization>");
            return true;
        }
        String targetCivName = args[1].toLowerCase();
        if (!this.civilizations.containsKey(targetCivName)) {
            player.sendMessage("\u00a7cCivilization not found!");
            return true;
        }
        if (targetCivName.equalsIgnoreCase(civName)) {
            player.sendMessage("\u00a7cYou cannot ally with your own civilization!");
            return true;
        }
        Set civAllies = this.alliances.getOrDefault(civName, new HashSet());
        if (civAllies.contains(targetCivName)) {
            player.sendMessage("\u00a7cYou are already allied with " + targetCivName);
            return true;
        }
        Set invites = this.allianceInvites.getOrDefault(targetCivName, new HashSet());
        if (invites.contains(civName)) {
            player.sendMessage("\u00a7cYou have already sent an alliance invite to " + targetCivName);
            return true;
        }
        invites.add(civName);
        this.allianceInvites.put(targetCivName, invites);
        player.sendMessage("\u00a7aAlliance invite sent to " + targetCivName);
        Civilization targetCiv = this.civilizations.get(targetCivName);
        UUID targetLeaderId = targetCiv.getLeaderId();
        if (targetLeaderId != null && (targetLeader = Bukkit.getPlayer((UUID)targetLeaderId)) != null) {
            targetLeader.sendMessage("\u00a76\u00a7lYou have received an alliance invite from " + civ.getName());
            targetLeader.sendMessage("\u00a7eUse \u00a7a/civilizations ally " + civ.getName() + " \u00a7eto accept the alliance");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleUnallyCommand(CommandSender sender, String[] args) {
        Player targetLeader;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou must be in a civilization to manage alliances!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (!civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the leader can manage alliances!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /civilizations unally <civilization>");
            return true;
        }
        String targetCivName = args[1].toLowerCase();
        if (!this.civilizations.containsKey(targetCivName)) {
            player.sendMessage("\u00a7cCivilization not found!");
            return true;
        }
        if (targetCivName.equalsIgnoreCase(civName)) {
            player.sendMessage("\u00a7cYou cannot unally your own civilization!");
            return true;
        }
        Set civAllies = this.alliances.getOrDefault(civName, new HashSet());
        if (!civAllies.contains(targetCivName)) {
            player.sendMessage("\u00a7cYou are not allied with " + targetCivName);
            return true;
        }
        civAllies.remove(targetCivName);
        this.alliances.put(civName, civAllies);
        Set targetAllies = this.alliances.getOrDefault(targetCivName, new HashSet());
        targetAllies.remove(civName);
        this.alliances.put(targetCivName, targetAllies);
        player.sendMessage("\u00a7aAlliance with " + targetCivName + " has been removed.");
        Civilization targetCiv = this.civilizations.get(targetCivName);
        UUID targetLeaderId = targetCiv.getLeaderId();
        if (targetLeaderId != null && (targetLeader = Bukkit.getPlayer((UUID)targetLeaderId)) != null) {
            targetLeader.sendMessage("\u00a7cYour alliance with " + civ.getName() + " has been removed.");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleRenameCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /civilizations rename <newname>");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (!civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the leader can rename the civilization!");
            return true;
        }
        String newName = args[1];
        if (this.civilizations.containsKey(newName.toLowerCase())) {
            player.sendMessage("\u00a7cA civilization with that name already exists!");
            return true;
        }
        String oldName = civ.getName();
        civ.setName(newName);
        this.civilizations.remove(civName);
        this.civilizations.put(newName.toLowerCase(), civ);
        for (Map.Entry<UUID, String> entry : new HashMap<UUID, String>(this.playerCivilizations).entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(civName)) continue;
            this.playerCivilizations.put(entry.getKey(), newName.toLowerCase());
        }
        if (this.claimedChunks.containsKey(civName)) {
            Set<Chunk> set = this.claimedChunks.remove(civName);
            this.claimedChunks.put(newName.toLowerCase(), set);
        }
        if (this.alliances.containsKey(civName)) {
            Set<String> set = this.alliances.remove(civName);
            this.alliances.put(newName.toLowerCase(), set);
            for (String ally : set) {
                Set allySet = this.alliances.getOrDefault(ally, new HashSet());
                if (!allySet.remove(civName)) continue;
                allySet.add(newName.toLowerCase());
                this.alliances.put(ally, allySet);
            }
        }
        if (this.allianceInvites.containsKey(civName)) {
            Set<String> set = this.allianceInvites.remove(civName);
            this.allianceInvites.put(newName.toLowerCase(), set);
        }
        for (Map.Entry<Object, Object> entry : this.allianceInvites.entrySet()) {
            if (!((Set)entry.getValue()).remove(civName)) continue;
            ((Set)entry.getValue()).add(newName.toLowerCase());
        }
        player.sendMessage("\u00a7aCivilization renamed from " + oldName + " to " + newName);
        this.saveConfiguration();
        return true;
    }

    private boolean handleKickCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /civilizations kick <player>");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (!civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the leader can kick members!");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        if (!this.playerCivilizations.containsKey(target.getUniqueId()) || !this.playerCivilizations.get(target.getUniqueId()).equalsIgnoreCase(civName)) {
            player.sendMessage("\u00a7cThis player is not in your civilization!");
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cUse /civilizations disband if you want to remove yourself!");
            return true;
        }
        if (civ.isLeader(target.getUniqueId())) {
            player.sendMessage("\u00a7cYou can't kick another leader!");
            return true;
        }
        this.playerCivilizations.remove(target.getUniqueId());
        civ.removeMember(target.getUniqueId());
        player.sendMessage("\u00a7aYou have kicked " + target.getName() + " from your civilization");
        target.sendMessage("\u00a7cYou have been kicked from " + civ.getName());
        for (UUID memberId : civ.getMemberIds()) {
            Player member = Bukkit.getPlayer((UUID)memberId);
            if (member == null || member.equals(player)) continue;
            member.sendMessage("\u00a76" + target.getName() + " has been kicked from your civilization.");
        }
        this.saveConfiguration();
        return true;
    }

    private boolean handleChatCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        boolean currentVisibility = this.chatVisibility.getOrDefault(player.getUniqueId(), false);
        this.chatVisibility.put(player.getUniqueId(), !currentVisibility);
        if (!currentVisibility) {
            player.sendMessage("\u00a7aCivilization chat enabled. Only your civilization members will see your messages.");
        } else {
            player.sendMessage("\u00a7aCivilization chat disabled. Everyone can see your messages again.");
        }
        return true;
    }

    private boolean handleDisbandCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            player.sendMessage("\u00a7cYou're not currently in any civilization!");
            return true;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            player.sendMessage("\u00a7cYour civilization couldn't be found!");
            return true;
        }
        if (!civ.isLeader(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the leader can disband the civilization!");
            return true;
        }
        for (UUID uUID : new HashSet<UUID>(this.playerCivilizations.keySet())) {
            if (!this.playerCivilizations.get(uUID).equalsIgnoreCase(civName)) continue;
            this.playerCivilizations.remove(uUID);
            Player member = Bukkit.getPlayer((UUID)uUID);
            if (member == null || member.equals(player)) continue;
            member.sendMessage("\u00a7cYour civilization " + civ.getName() + " has been disbanded!");
        }
        this.claimedChunks.remove(civName);
        this.alliances.remove(civName);
        this.allianceInvites.remove(civName);
        for (Set set : this.alliances.values()) {
            set.remove(civName);
        }
        for (Set set : this.allianceInvites.values()) {
            set.remove(civName);
        }
        this.civilizations.remove(civName);
        player.sendMessage("\u00a7aYour civilization " + civ.getName() + " has been disbanded.");
        this.saveConfiguration();
        return true;
    }

    private boolean handleConfigCommand(CommandSender sender, String[] args) {
        if (args.length < 2 || !args[1].equalsIgnoreCase("reload")) {
            sender.sendMessage("\u00a7cUsage: /civilizations config reload");
            return true;
        }
        if (!sender.hasPermission("civilizations.config") && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        this.reloadConfig();
        this.loadConfiguration();
        sender.sendMessage("\u00a7aConfiguration reloaded successfully!");
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getView().getTitle() == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String civName = this.playerCivilizations.get(player.getUniqueId());
        if (civName == null) {
            return;
        }
        Civilization civ = this.civilizations.get(civName);
        if (civ == null) {
            return;
        }
        String guiTitle = "\u00a76" + civ.getName();
        if (!event.getView().getTitle().equals(guiTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = clicked.getItemMeta().getDisplayName();
        if (name != null && name.contains(civ.getName())) {
            Inventory membersGui = Bukkit.createInventory(null, (int)27, (String)("\u00a76" + civ.getName() + " Members"));
            UUID leaderId = civ.getLeaderId();
            if (leaderId != null) {
                ItemStack leaderItem = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta meta = leaderItem.getItemMeta();
                meta.setDisplayName("\u00a76" + Bukkit.getOfflinePlayer((UUID)leaderId).getName());
                meta.setLore(Collections.singletonList("\u00a76Rank: Leader"));
                leaderItem.setItemMeta(meta);
                membersGui.addItem(new ItemStack[]{leaderItem});
            }
            for (UUID memberId : civ.getMemberIds()) {
                if (memberId.equals(leaderId)) continue;
                ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta meta = head.getItemMeta();
                meta.setDisplayName("\u00a7f" + Bukkit.getOfflinePlayer((UUID)memberId).getName());
                meta.setLore(Collections.singletonList("\u00a76Rank: Member"));
                head.setItemMeta(meta);
                membersGui.addItem(new ItemStack[]{head});
            }
            player.openInventory(membersGui);
        }
    }

    @EventHandler
    public void onFriendlyFire(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player) || !(event.getEntity() instanceof Player)) {
            return;
        }
        Player attacker = (Player)event.getDamager();
        Player victim = (Player)event.getEntity();
        String attackerCiv = this.playerCivilizations.get(attacker.getUniqueId());
        String victimCiv = this.playerCivilizations.get(victim.getUniqueId());
        if (attackerCiv != null && victimCiv != null) {
            if (attackerCiv.equalsIgnoreCase(victimCiv)) {
                attacker.sendMessage("\u00a7cYou can't hurt members of your civilization!");
                event.setCancelled(true);
                return;
            }
            Set attackerAllies = this.alliances.getOrDefault(attackerCiv.toLowerCase(), Collections.emptySet());
            if (attackerAllies.contains(victimCiv.toLowerCase())) {
                attacker.sendMessage("\u00a7cYou can't hurt members of allied civilizations!");
                event.setCancelled(true);
                return;
            }
        }
        if (this.groupManager.isFriendlyFireGroup(attacker, victim)) {
            event.setCancelled(true);
            return;
        }
    }

    class UpkeepTask
    extends BukkitRunnable {
        private final CivilizationsPlugin plugin;

        public UpkeepTask(CivilizationsPlugin plugin) {
            this.plugin = plugin;
        }

        public void run() {
            if (!this.plugin.vaultEnabled || !this.plugin.getConfig().getBoolean("economy.upkeep.enabled", true)) {
                return;
            }
            double costPerChunk = this.plugin.getConfig().getDouble("economy.upkeep.cost-per-chunk", 100.0);
            if (costPerChunk <= 0.0) {
                return;
            }
            this.plugin.getLogger().info("Running civilization upkeep task...");
            for (Map.Entry<String, Civilization> entry : new HashMap<String, Civilization>(this.plugin.civilizations).entrySet()) {
                String civName = entry.getKey();
                Civilization civ = entry.getValue();
                Set civClaims = this.plugin.claimedChunks.getOrDefault(civName, Collections.emptySet());
                if (civClaims.isEmpty()) continue;
                final double totalUpkeep = (double)civClaims.size() * costPerChunk;
                if (civ.getBankBalance() < totalUpkeep) {
                    this.plugin.claimedChunks.remove(civName);
                    this.plugin.getLogger().warning("Civilization " + civ.getName() + " could not pay upkeep of " + totalUpkeep + ". All land has been unclaimed.");
                    final UUID leaderId = civ.getLeaderId();
                    if (leaderId == null) continue;
                    new BukkitRunnable(){

                        public void run() {
                            Player leader = Bukkit.getPlayer((UUID)leaderId);
                            if (leader != null) {
                                leader.sendMessage("\u00a7c\u00a7lYour civilization could not afford its weekly upkeep of " + String.format("%.2f", totalUpkeep) + "!");
                                leader.sendMessage("\u00a7c\u00a7lAll of your civilization's land has been lost!");
                            }
                        }
                    }.runTask((Plugin)this.plugin);
                    continue;
                }
                civ.withdraw(totalUpkeep);
                this.plugin.getLogger().info("Civilization " + civ.getName() + " paid " + totalUpkeep + " in upkeep for " + civClaims.size() + " chunks.");
            }
            new BukkitRunnable(){

                public void run() {
                    UpkeepTask.this.plugin.saveConfiguration();
                }
            }.runTask((Plugin)this.plugin);
            this.plugin.getLogger().info("Civilization upkeep task finished.");
        }
    }
}

