/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import java.text.DecimalFormat;
import java.util.HexFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_897;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    private static final class_6862<class_1299<?>> BOSS_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"c", (String)"bosses"));

    private static class_1297 getEntityLookedAt(class_1297 e) {
        class_1297 foundEntity = null;
        double finalDistance = 32.0;
        class_239 pos = HealthBarRenderer.raycast(e, 32.0);
        class_243 positionVector = e.method_33571();
        double distance = pos.method_17784().method_1022(positionVector);
        class_243 lookVector = e.method_5720();
        class_243 reachVector = positionVector.method_1031(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0);
        List entitiesInBoundingBox = e.method_37908().method_8335(e, e.method_5829().method_1009(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0).method_1012(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (class_1297 entity : entitiesInBoundingBox) {
            class_1297 lookedEntity = null;
            if (entity.method_5863()) {
                double distanceToEntity;
                class_238 collisionBox = entity.method_5829();
                Optional interceptPosition = collisionBox.method_992(positionVector, reachVector);
                if (collisionBox.method_1006(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.method_1022((class_243)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance)) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static class_239 raycast(class_1297 e, double len) {
        class_243 origin = e.method_33571();
        class_243 ray = e.method_5720();
        class_243 next = origin.method_1019(ray.method_1029().method_1021(len));
        return e.method_37908().method_17742(new class_3959(origin, next, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, e));
    }

    private static class_1799 getIcon(class_1309 entity, boolean boss) {
        if (boss) {
            return new class_1799((class_1935)class_1802.field_8137);
        }
        class_1299 type = entity.method_5864();
        if (type.method_20210(class_3483.field_48289)) {
            return new class_1799((class_1935)class_1802.field_8680);
        }
        if (type.method_20210(class_3483.field_46232)) {
            return new class_1799((class_1935)class_1802.field_8511);
        }
        if (type.method_20210(class_3483.field_48287)) {
            return new class_1799((class_1935)class_1802.field_8475);
        }
        return class_1799.field_8037;
    }

    private static int getColor(class_1309 entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            } else if (!entity.method_5864().method_5891().method_6136()) {
                r = 255;
                g = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = class_3532.method_15363((float)entity.method_6032(), (float)0.0f, (float)entity.method_6063());
        float hue = Math.max(0.0f, health / entity.method_6063() / 3.0f - 0.07f);
        return class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f);
    }

    public static boolean isBoss(class_1297 entity) {
        return entity.method_5864().method_20210(BOSS_TAG);
    }

    private static boolean shouldShowPlate(class_1309 living, class_1297 cameraEntity) {
        class_1657 cameraPlayer;
        if (living == cameraEntity) {
            return false;
        }
        if (!NeatConfig.instance.renderInF1() && !class_310.method_1498() || !NeatConfig.draw) {
            return false;
        }
        class_2960 id = class_7923.field_41177.method_10221((Object)living.method_5864());
        if (NeatConfig.instance.blacklist().contains(id.toString())) {
            return false;
        }
        float distance = living.method_5739(cameraEntity);
        if (distance > (float)NeatConfig.instance.maxDistance() || distance > (float)NeatConfig.instance.maxDistanceWithoutLineOfSight() && !living.method_6057(cameraEntity)) {
            return false;
        }
        if (!NeatConfig.instance.showOnBosses() && HealthBarRenderer.isBoss((class_1297)living)) {
            return false;
        }
        if (!NeatConfig.instance.showOnPlayers() && living instanceof class_1657) {
            return false;
        }
        if (!NeatConfig.instance.showFullHealth() && living.method_6032() >= living.method_6063()) {
            return false;
        }
        if (NeatConfig.instance.showOnlyFocused() && HealthBarRenderer.getEntityLookedAt(cameraEntity) != living) {
            return false;
        }
        if (!NeatConfig.instance.showOnPassive() && living.method_5864().method_5891().method_6136()) {
            return false;
        }
        if (!(NeatConfig.instance.showOnHostile() || living.method_5864().method_5891().method_6136() || HealthBarRenderer.isBoss((class_1297)living))) {
            return false;
        }
        if (living.method_5626(cameraEntity)) {
            return false;
        }
        boolean visible = true;
        if (cameraEntity instanceof class_1657 && living.method_5756(cameraPlayer = (class_1657)cameraEntity)) {
            boolean wearingThings = false;
            for (class_1799 armorSlot : living.method_5661()) {
                if (armorSlot.method_7960()) continue;
                wearingThings = true;
            }
            for (class_1799 handSlot : living.method_5877()) {
                if (handSlot.method_7960()) continue;
                wearingThings = true;
            }
            if (!wearingThings) {
                visible = false;
            }
        }
        class_268 livingTeam = living.method_5781();
        class_268 cameraTeam = cameraEntity.method_5781();
        if (livingTeam != null) {
            return switch (livingTeam.method_1201()) {
                default -> throw new MatchException(null, null);
                case class_270.class_272.field_1442 -> visible;
                case class_270.class_272.field_1443 -> false;
                case class_270.class_272.field_1444 -> {
                    if (cameraTeam == null) {
                        yield visible;
                    }
                    if (livingTeam.method_1206((class_270)cameraTeam) && (livingTeam.method_1199() || visible)) {
                        yield true;
                    }
                    yield false;
                }
                case class_270.class_272.field_1446 -> cameraTeam == null ? visible : !livingTeam.method_1206((class_270)cameraTeam) && visible;
            };
        }
        return visible;
    }

    public static <E extends class_1297, S extends class_10017> void hookRender(class_1297 entity, class_4587 poseStack, class_4597 buffers, class_4184 camera, class_897<? super E, S> entityRenderer, float partialTicks, double x, double y, double z) {
        int armor;
        class_310 mc = class_310.method_1551();
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        if (!HealthBarRenderer.shouldShowPlate(living, camera.method_19331())) {
            return;
        }
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = NeatConfig.instance.barHeight();
        boolean boss = HealthBarRenderer.isBoss((class_1297)living);
        String name = living.method_16914() ? String.valueOf(class_124.field_1056) + living.method_5797().getString() : living.method_5476().getString();
        float nameLen = (float)mc.field_1772.method_1727(name) * 0.5f;
        float halfSize = Math.max((float)NeatConfig.instance.plateSize(), nameLen / 2.0f + 10.0f);
        class_10017 renderState = entityRenderer.method_55269();
        class_243 vec3 = entityRenderer.method_23169(renderState);
        double d2 = x + vec3.method_10216();
        double d3 = y + vec3.method_10214();
        double d0 = z + vec3.method_10215();
        poseStack.method_22903();
        poseStack.method_22904(d2, d3, d0);
        poseStack.method_22904(0.0, (double)living.method_17682() + NeatConfig.instance.heightAbove(), 0.0);
        poseStack.method_22907(camera.method_23767());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        poseStack.method_22903();
        poseStack.method_22905(-0.0267f, -0.0267f, 0.0267f);
        if (NeatConfig.instance.drawBackground()) {
            float padding = NeatConfig.instance.backgroundPadding();
            int bgHeight = NeatConfig.instance.backgroundHeight();
            if (!NeatConfig.instance.showEntityName()) {
                bgHeight -= 4;
            }
            class_4588 builder = buffers.getBuffer(NeatRenderType.BACKGROUND_RENDER_TYPE);
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize - padding, (float)(-bgHeight), 0.01f).method_1336(0, 0, 0, 60).method_22913(0.0f, 0.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize - padding, (float)barHeight + padding, 0.01f).method_1336(0, 0, 0, 60).method_22913(0.0f, 0.5f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize + padding, (float)barHeight + padding, 0.01f).method_1336(0, 0, 0, 60).method_22913(1.0f, 0.5f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize + padding, (float)(-bgHeight), 0.01f).method_1336(0, 0, 0, 60).method_22913(1.0f, 0.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        }
        int argb = HealthBarRenderer.getColor(living, NeatConfig.instance.colorByType(), boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float maxHealth = Math.max(living.method_6032(), living.method_6063());
        float healthHalfSize = halfSize * (living.method_6032() / maxHealth);
        class_4588 builder = buffers.getBuffer(NeatRenderType.BAR_RENDER_TYPE);
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize, 0.0f, 0.001f).method_1336(r, g, b, 127).method_22913(0.0f, 0.75f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize, (float)barHeight, 0.001f).method_1336(r, g, b, 127).method_22913(0.0f, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).method_1336(r, g, b, 127).method_22913(1.0f, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).method_1336(r, g, b, 127).method_22913(1.0f, 0.75f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        if (healthHalfSize < halfSize) {
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).method_1336(0, 0, 0, 127).method_22913(0.0f, 0.5f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).method_1336(0, 0, 0, 127).method_22913(0.0f, 0.75f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize, (float)barHeight, 0.001f).method_1336(0, 0, 0, 127).method_22913(1.0f, 0.75f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize, 0.0f, 0.001f).method_1336(0, 0, 0, 127).method_22913(1.0f, 0.5f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(poseStack.method_23760(), 0.0f, 0.0f, 0.0f);
        }
        int textColor = HexFormat.fromHexDigits(NeatConfig.instance.textColor());
        boolean black = false;
        if (NeatConfig.instance.showEntityName()) {
            poseStack.method_22903();
            poseStack.method_46416(-halfSize, -4.5f, 0.0f);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            mc.field_1772.method_27521(name, 0.0f, 0.0f, textColor, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
            poseStack.method_22909();
        }
        float healthValueTextScale = 0.375f;
        poseStack.method_22903();
        poseStack.method_46416(-halfSize, -4.5f, 0.0f);
        poseStack.method_22905(0.375f, 0.375f, 0.375f);
        int h = NeatConfig.instance.hpTextHeight();
        DecimalFormat health_format = new DecimalFormat(NeatConfig.instance.decimalFormat());
        if (NeatConfig.instance.showCurrentHP()) {
            String hpStr = health_format.format(living.method_6032());
            mc.field_1772.method_27521(hpStr, 2.0f, (float)h, textColor, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showMaxHP()) {
            String maxHpStr = String.valueOf(class_124.field_1067) + health_format.format(living.method_6063());
            mc.field_1772.method_27521(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - mc.field_1772.method_1727(maxHpStr) - 2), (float)h, textColor, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showPercentage()) {
            String percStr = (int)(100.0f * living.method_6032() / living.method_6063()) + "%";
            mc.field_1772.method_27521(percStr, (float)((int)(halfSize / 0.375f)) - (float)mc.field_1772.method_1727(percStr) / 2.0f, (float)h, textColor, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
        if (NeatConfig.instance.enableDebugInfo() && mc.method_53526().method_53536()) {
            class_2960 id = class_7923.field_41177.method_10221((Object)living.method_5864());
            mc.field_1772.method_27521("ID: \"" + String.valueOf(id) + "\"", 0.0f, (float)(h + 16), textColor, false, poseStack.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
        poseStack.method_22909();
        poseStack.method_22909();
        float zBump = -0.1f;
        poseStack.method_22903();
        float iconOffset = 2.85f;
        float zShift = 0.0f;
        if (NeatConfig.instance.showAttributes()) {
            class_1799 icon = HealthBarRenderer.getIcon(living, boss);
            HealthBarRenderer.renderIcon(living.method_37908(), icon, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
            iconOffset += 5.0f;
            zShift += -0.1f;
        }
        if ((armor = living.method_6096()) > 0 && NeatConfig.instance.showArmor()) {
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.instance.groupArmor()) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            class_1799 iron = new class_1799((class_1935)class_1802.field_8523);
            for (int i = 0; i < ironArmor; ++i) {
                HealthBarRenderer.renderIcon(living.method_37908(), iron, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
            class_1799 diamond = new class_1799((class_1935)class_1802.field_8058);
            for (int i = 0; i < diamondArmor; ++i) {
                HealthBarRenderer.renderIcon(living.method_37908(), diamond, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
        }
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private static void renderIcon(class_1937 level, class_1799 icon, class_4587 poseStack, class_4597 buffers, float globalScale, float halfSize, float leftShift, float zShift) {
        if (!icon.method_7960()) {
            float iconScale = 0.12f;
            poseStack.method_22903();
            double dx = (double)((halfSize - leftShift) * globalScale) + NeatConfig.instance.iconOffsetX();
            double dy = 3.0f * globalScale;
            double dz = zShift * globalScale;
            poseStack.method_22904(-dx, dy + NeatConfig.instance.iconOffsetY(), dz);
            poseStack.method_22905(0.12f, 0.12f, 0.12f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            class_310.method_1551().method_1480().method_23178(icon, class_811.field_4315, 0xF000F0, class_4608.field_21444, poseStack, buffers, level, 0);
            poseStack.method_22909();
        }
    }
}

