/*
 * Decompiled with CFR 0.152.
 */
package net.riser876.deepsea.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.riser876.deepsea.config.Config;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "deepsea.json";
    public static Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("deepsea.json");
    public static Config CONFIG;

    public static void loadConfig() {
        if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
            ConfigManager.loadDefaultConfig();
            return;
        }
        try {
            String json = Files.readString(CONFIG_PATH);
            CONFIG = (Config)GSON.fromJson(json, Config.class);
            ConfigManager.saveConfig();
        }
        catch (JsonSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadDefaultConfig() {
        CONFIG = new Config();
        ConfigManager.saveConfig();
    }

    private static void saveConfig() {
        try {
            String json = GSON.toJson((Object)CONFIG);
            Files.write(CONFIG_PATH, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

