/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.tictactoex;

import com.Mateitaa1.tictactoex.TicTacToeX;
import java.util.Arrays;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GameSession {
    private final TicTacToeX plugin;
    private final Player player1;
    private final Player player2;
    private final Economy economy;
    private final Inventory gameInventory;
    private final char[] board;
    private Player currentPlayer;
    private boolean gameEnded;
    private double betAmount;
    private boolean isCashGame;
    private static final int[][] WIN_CONDITIONS = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {0, 3, 6}, {1, 4, 7}, {2, 5, 8}, {0, 4, 8}, {2, 4, 6}};

    public GameSession(TicTacToeX plugin, Player player1, Player player2, Economy economy) {
        this.plugin = plugin;
        this.player1 = player1;
        this.player2 = player2;
        this.economy = economy;
        this.board = new char[9];
        Arrays.fill(this.board, ' ');
        this.currentPlayer = player1;
        this.gameEnded = false;
        this.gameInventory = Bukkit.createInventory(null, 54, String.valueOf((Object)ChatColor.DARK_BLUE) + "TicTacToe Game");
        this.setupInventory();
    }

    public void setBetAmount(double amount) {
        this.betAmount = amount;
        this.isCashGame = amount > 0.0;
    }

    private void setupInventory() {
        int[] gameSlots;
        ItemStack border = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta borderMeta = border.getItemMeta();
        borderMeta.setDisplayName(String.valueOf((Object)ChatColor.GRAY));
        border.setItemMeta(borderMeta);
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i < 45 && i % 9 != 0 && i % 9 != 8) continue;
            this.gameInventory.setItem(i, border);
        }
        for (int slot : gameSlots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39}) {
            ItemStack empty = new ItemStack(Material.WHITE_STAINED_GLASS_PANE);
            ItemMeta emptyMeta = empty.getItemMeta();
            emptyMeta.setDisplayName(String.valueOf((Object)ChatColor.WHITE) + "Empty");
            emptyMeta.setLore(Arrays.asList(String.valueOf((Object)ChatColor.GRAY) + "Click to place your mark"));
            empty.setItemMeta(emptyMeta);
            this.gameInventory.setItem(slot, empty);
        }
        this.updatePlayerIndicators();
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        infoMeta.setDisplayName(String.valueOf((Object)ChatColor.GOLD) + "Game Info");
        infoMeta.setLore(Arrays.asList(String.valueOf((Object)ChatColor.YELLOW) + "Players: " + this.player1.getName() + " vs " + this.player2.getName(), this.isCashGame ? String.valueOf((Object)ChatColor.GREEN) + "Pot: $" + this.betAmount * 2.0 + " (Each bet $" + this.betAmount + ")" : String.valueOf((Object)ChatColor.BLUE) + "Friendly Game", String.valueOf((Object)ChatColor.GRAY) + "Current Turn: " + this.currentPlayer.getName()));
        info.setItemMeta(infoMeta);
        this.gameInventory.setItem(4, info);
    }

    private void updatePlayerIndicators() {
        ItemStack p1Item = new ItemStack(Material.RED_WOOL);
        ItemMeta p1Meta = p1Item.getItemMeta();
        p1Meta.setDisplayName(String.valueOf((Object)ChatColor.RED) + this.player1.getName() + " (X)");
        p1Meta.setLore(Arrays.asList(this.currentPlayer.equals(this.player1) ? String.valueOf((Object)ChatColor.GREEN) + "Your Turn!" : String.valueOf((Object)ChatColor.GRAY) + "Waiting..."));
        p1Item.setItemMeta(p1Meta);
        this.gameInventory.setItem(10, p1Item);
        ItemStack p2Item = new ItemStack(Material.BLUE_WOOL);
        ItemMeta p2Meta = p2Item.getItemMeta();
        p2Meta.setDisplayName(String.valueOf((Object)ChatColor.BLUE) + this.player2.getName() + " (O)");
        p2Meta.setLore(Arrays.asList(this.currentPlayer.equals(this.player2) ? String.valueOf((Object)ChatColor.GREEN) + "Your Turn!" : String.valueOf((Object)ChatColor.GRAY) + "Waiting..."));
        p2Item.setItemMeta(p2Meta);
        this.gameInventory.setItem(16, p2Item);
    }

    public void start() {
        if (this.isCashGame && this.economy != null) {
            if (this.economy.has((OfflinePlayer)this.player1, this.betAmount) && this.economy.has((OfflinePlayer)this.player2, this.betAmount)) {
                this.economy.withdrawPlayer((OfflinePlayer)this.player1, this.betAmount);
                this.economy.withdrawPlayer((OfflinePlayer)this.player2, this.betAmount);
                this.player1.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "$" + this.betAmount + " has been deducted from your account");
                this.player2.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "$" + this.betAmount + " has been deducted from your account");
            } else {
                this.player1.sendMessage(String.valueOf((Object)ChatColor.RED) + "Game cancelled - insufficient funds");
                this.player2.sendMessage(String.valueOf((Object)ChatColor.RED) + "Game cancelled - insufficient funds");
                this.cleanup();
                return;
            }
        }
        this.player1.openInventory(this.gameInventory);
        this.player2.openInventory(this.gameInventory);
        this.player1.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Game started! You are X (Red)");
        this.player2.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Game started! You are O (Blue)");
        this.player1.playSound(this.player1.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        this.player2.playSound(this.player2.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    public void handleClick(Player player, int slot) {
        char symbol;
        if (this.gameEnded || !player.equals(this.currentPlayer)) {
            return;
        }
        int boardPos = this.getBoardPosition(slot);
        if (boardPos == -1 || this.board[boardPos] != ' ') {
            return;
        }
        this.board[boardPos] = symbol = player.equals(this.player1) ? (char)'X' : 'O';
        this.updateBoardDisplay(slot, player);
        if (this.checkWin(symbol)) {
            this.endGame(player);
        } else if (this.isBoardFull()) {
            this.endGame(null);
        } else {
            this.currentPlayer = this.currentPlayer.equals(this.player1) ? this.player2 : this.player1;
            this.updatePlayerIndicators();
            this.player1.playSound(this.player1.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.player2.playSound(this.player2.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private int getBoardPosition(int inventorySlot) {
        int[] gameSlots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
        for (int i = 0; i < gameSlots.length; ++i) {
            if (gameSlots[i] != inventorySlot) continue;
            return i;
        }
        return -1;
    }

    private void updateBoardDisplay(int slot, Player player) {
        ItemMeta meta;
        ItemStack item;
        if (player.equals(this.player1)) {
            item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf((Object)ChatColor.RED) + "X - " + this.player1.getName());
        } else {
            item = new ItemStack(Material.BLUE_STAINED_GLASS_PANE);
            meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf((Object)ChatColor.BLUE) + "O - " + this.player2.getName());
        }
        meta.setLore(Arrays.asList(String.valueOf((Object)ChatColor.GRAY) + "Claimed"));
        item.setItemMeta(meta);
        this.gameInventory.setItem(slot, item);
    }

    private boolean checkWin(char symbol) {
        for (int[] condition : WIN_CONDITIONS) {
            if (this.board[condition[0]] != symbol || this.board[condition[1]] != symbol || this.board[condition[2]] != symbol) continue;
            return true;
        }
        return false;
    }

    private boolean isBoardFull() {
        for (char c : this.board) {
            if (c != ' ') continue;
            return false;
        }
        return true;
    }

    private void endGame(Player winner) {
        this.gameEnded = true;
        if (winner != null) {
            if (this.isCashGame && this.economy != null) {
                double totalPot = this.betAmount * 2.0;
                this.economy.depositPlayer((OfflinePlayer)winner, totalPot);
                winner.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "You won the pot of $" + totalPot + "!");
                Player loser = winner.equals(this.player1) ? this.player2 : this.player1;
                loser.sendMessage(String.valueOf((Object)ChatColor.RED) + "You lost your bet of $" + this.betAmount + "!");
                loser.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + winner.getName() + " won the pot of $" + totalPot);
            } else {
                winner.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "You won the game!");
                Player loser = winner.equals(this.player1) ? this.player2 : this.player1;
                loser.sendMessage(String.valueOf((Object)ChatColor.RED) + "You lost the game!");
            }
            winner.playSound(winner.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            Player loser = winner.equals(this.player1) ? this.player2 : this.player1;
            loser.playSound(loser.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        } else {
            if (this.isCashGame && this.economy != null) {
                this.economy.depositPlayer((OfflinePlayer)this.player1, this.betAmount);
                this.economy.depositPlayer((OfflinePlayer)this.player2, this.betAmount);
                this.player1.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Game drawn! Your bet of $" + this.betAmount + " has been returned.");
                this.player2.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Game drawn! Your bet of $" + this.betAmount + " has been returned.");
            } else {
                this.player1.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Game drawn!");
                this.player2.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Game drawn!");
            }
            this.player1.playSound(this.player1.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.5f);
            this.player2.playSound(this.player2.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.5f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.player1.closeInventory();
            this.player2.closeInventory();
            this.cleanup();
        }, 60L);
    }

    public void cleanup() {
        this.plugin.endSession(this);
    }

    public boolean isGameInventory(Inventory inventory) {
        return inventory.equals(this.gameInventory);
    }

    public Player getPlayer1() {
        return this.player1;
    }

    public Player getPlayer2() {
        return this.player2;
    }
}

