/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.tictactoex;

import com.Mateitaa1.tictactoex.GameSession;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class TicTacToeX
extends JavaPlugin
implements Listener {
    private Economy economy = null;
    private Map<UUID, GameSession> activeSessions = new HashMap<UUID, GameSession>();
    private Map<UUID, GameInvite> pendingInvites = new HashMap<UUID, GameInvite>();

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        if (!this.setupEconomy()) {
            this.getLogger().warning("Vault not found! Cash games will be disabled.");
        }
        this.getLogger().info("TicTacToeX has been enabled!");
    }

    @Override
    public void onDisable() {
        for (GameSession session : this.activeSessions.values()) {
            session.cleanup();
        }
        this.activeSessions.clear();
        this.pendingInvites.clear();
        this.getLogger().info("TicTacToeX has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider<Economy> rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = rsp.getProvider();
        return this.economy != null;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("tictactoe")) {
            if (args.length == 0) {
                player.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "Usage: /tictactoe <cash|friendly> [player] [amount]");
                return true;
            }
            String gameType = args[0].toLowerCase();
            if (gameType.equals("cash")) {
                double amount;
                if (this.economy == null) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Economy system not available!");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /tictactoe cash <player> <amount>");
                    return true;
                }
                Player target = Bukkit.getPlayer(args[1]);
                if (target == null) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found!");
                    return true;
                }
                if (target.equals(player)) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You cannot play against yourself!");
                    return true;
                }
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Invalid amount!");
                    return true;
                }
                if (amount <= 0.0) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Amount must be positive!");
                    return true;
                }
                if (!this.economy.has((OfflinePlayer)player, amount)) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have enough money!");
                    return true;
                }
                if (!this.economy.has((OfflinePlayer)target, amount)) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Target player doesn't have enough money!");
                    return true;
                }
                this.sendGameInvite(player, target, amount);
            } else if (gameType.equals("friendly")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /tictactoe friendly <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer(args[1]);
                if (target == null) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found!");
                    return true;
                }
                if (target.equals(player)) {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You cannot play against yourself!");
                    return true;
                }
                this.sendGameInvite(player, target, 0.0);
            } else {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Invalid game type! Use 'cash' or 'friendly'");
            }
        } else if (command.getName().equalsIgnoreCase("tttaccept")) {
            this.acceptGameInvite(player);
        } else if (command.getName().equalsIgnoreCase("tttdeny")) {
            this.denyGameInvite(player);
        }
        return true;
    }

    private void sendGameInvite(Player inviter, Player target, double amount) {
        if (this.activeSessions.containsKey(inviter.getUniqueId()) || this.activeSessions.containsKey(target.getUniqueId())) {
            inviter.sendMessage(String.valueOf((Object)ChatColor.RED) + "One of the players is already in a game!");
            return;
        }
        this.pendingInvites.put(target.getUniqueId(), new GameInvite(inviter.getUniqueId(), amount));
        if (amount > 0.0) {
            target.sendMessage(String.valueOf((Object)ChatColor.GOLD) + inviter.getName() + " has challenged you to a cash game for $" + amount);
            inviter.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Invite sent to " + target.getName() + " for $" + amount);
        } else {
            target.sendMessage(String.valueOf((Object)ChatColor.GOLD) + inviter.getName() + " has challenged you to a friendly game");
            inviter.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Invite sent to " + target.getName());
        }
        target.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Use /tttaccept to accept or /tttdeny to deny");
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.pendingInvites.containsKey(target.getUniqueId())) {
                this.pendingInvites.remove(target.getUniqueId());
                target.sendMessage(String.valueOf((Object)ChatColor.RED) + "Game invite expired");
                inviter.sendMessage(String.valueOf((Object)ChatColor.RED) + "Your game invite to " + target.getName() + " expired");
            }
        }, 600L);
    }

    private void acceptGameInvite(Player player) {
        GameInvite invite = this.pendingInvites.remove(player.getUniqueId());
        if (invite == null) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "No pending game invites!");
            return;
        }
        Player inviter = Bukkit.getPlayer(invite.inviterUUID);
        if (inviter == null) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Inviter is no longer online!");
            return;
        }
        this.startGame(inviter, player, invite.betAmount);
    }

    private void denyGameInvite(Player player) {
        GameInvite invite = this.pendingInvites.remove(player.getUniqueId());
        if (invite == null) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "No pending game invites!");
            return;
        }
        Player inviter = Bukkit.getPlayer(invite.inviterUUID);
        if (inviter != null) {
            inviter.sendMessage(String.valueOf((Object)ChatColor.RED) + player.getName() + " denied your game invite");
        }
        player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Game invite denied");
    }

    private void startGame(Player player1, Player player2, double betAmount) {
        GameSession session = new GameSession(this, player1, player2, this.economy);
        session.setBetAmount(betAmount);
        this.activeSessions.put(player1.getUniqueId(), session);
        this.activeSessions.put(player2.getUniqueId(), session);
        session.start();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        GameSession session = this.activeSessions.get(player.getUniqueId());
        if (session != null && session.isGameInventory(event.getInventory())) {
            event.setCancelled(true);
            session.handleClick(player, event.getSlot());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        GameSession session = this.activeSessions.get(player.getUniqueId());
        if (session != null && session.isGameInventory(event.getInventory())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (this.activeSessions.containsKey(player.getUniqueId())) {
                    player.openInventory(event.getInventory());
                }
            }, 1L);
        }
    }

    public void endSession(GameSession session) {
        this.activeSessions.remove(session.getPlayer1().getUniqueId());
        this.activeSessions.remove(session.getPlayer2().getUniqueId());
    }

    public Economy getEconomy() {
        return this.economy;
    }

    private static class GameInvite {
        public final UUID inviterUUID;
        public final double betAmount;

        public GameInvite(UUID inviterUUID, double betAmount) {
            this.inviterUUID = inviterUUID;
            this.betAmount = betAmount;
        }
    }
}

