/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.enchantment_color;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.kapitencraft.kap_lib.util.range.simple.IntegerNumberRange;
import net.minecraft.util.Mth;

public class LevelRange
extends IntegerNumberRange {
    static final Codec<LevelRange> CODEC = RecordCodecBuilder.create(levelRangeInstance -> levelRangeInstance.group((App)Codec.LONG.fieldOf("packed").forGetter(IntegerNumberRange::pack), (App)Codec.BOOL.optionalFieldOf("relative", (Object)false).forGetter(LevelRange::isMaxLevelRelative)).apply((Applicative)levelRangeInstance, LevelRange::fromCodec));
    private final boolean maxLevelRelative;

    private static LevelRange fromCodec(long in, Boolean relative) {
        return new LevelRange((int)(in << 32), (int)in, relative);
    }

    public LevelRange(int min, int max, boolean maxLevelRelative) {
        super(Mth.clamp((int)min, (int)-255, (int)255), Mth.clamp((int)max, (int)-255, (int)255));
        if (max < min) {
            throw new IllegalArgumentException("min on level range smaller than max");
        }
        this.maxLevelRelative = maxLevelRelative;
    }

    public boolean isMaxLevelRelative() {
        return this.maxLevelRelative;
    }

    public LevelRange setRelative(boolean relative) {
        return new LevelRange(this.getMin(), this.getMax(), relative);
    }

    public LevelRange withMin(int min) {
        return new LevelRange(min, this.getMax(), this.maxLevelRelative);
    }

    public LevelRange withMax(int max) {
        return new LevelRange(this.getMin(), max, this.maxLevelRelative);
    }

    public boolean test(int level, int maxLevel) {
        return super.test(this.maxLevelRelative ? level - maxLevel : level);
    }
}

