/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.gui;

import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityMenu<BE extends BlockEntity>
extends AbstractContainerMenu {
    private final int slotAmount;
    protected final Level level;
    public final Player player;
    protected final BE blockEntity;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    public static final int VANILLA_SLOT_COUNT = 36;
    public static final int VANILLA_FIRST_SLOT_INDEX = 0;
    public static final int BE_INVENTORY_FIRST_SLOT_INDEX = 36;

    protected BlockEntityMenu(@Nullable MenuType<?> menuType, int containerId, int slotAmount, Inventory inventory, BE provider) {
        super(menuType, containerId);
        this.slotAmount = slotAmount;
        this.player = inventory.player;
        this.level = this.player.level();
        this.blockEntity = provider;
    }

    public void addPlayerInventories(Inventory inventory, int xOffset, int yOffset) {
        this.addPlayerInventory(inventory, xOffset, yOffset);
        this.addPlayerHotbar(inventory, xOffset, yOffset);
    }

    private void addPlayerInventory(Inventory playerInventory, int xOffset, int yOffSet) {
        MiscHelper.repeat(3, i -> MiscHelper.repeat(9, l -> this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, xOffset + 8 + l * 18, yOffSet + 84 + i * 18))));
    }

    private void addPlayerHotbar(Inventory playerInventory, int xOffset, int yOffSet) {
        MiscHelper.repeat(9, i -> this.addSlot(new Slot((Container)playerInventory, i.intValue(), xOffset + 8 + i * 18, yOffSet + 142)));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 36 + this.slotAmount, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 36 + this.slotAmount) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            KapLibMod.LOGGER.warn("Invalid slotIndex: {}", (Object)index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public BE getCapabilityProvider() {
        return this.blockEntity;
    }
}

