/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.box;

import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;

public class RenderBox {
    public Vec2 start;
    public Vec2 end;
    private final int cursorType;
    private final int color;

    public RenderBox(Vec2 start, Vec2 end, int cursorType, int color) {
        this.start = start;
        this.end = end;
        this.cursorType = cursorType;
        this.color = color;
    }

    protected float width() {
        return Math.abs(this.end.x - this.start.x);
    }

    protected float height() {
        return Math.abs(this.end.y - this.start.y);
    }

    public int getCursorType(double mouseX, double mouseY) {
        return this.cursorType;
    }

    public void move(Vec2 toAdd) {
        this.start = this.start.add(toAdd);
        this.end = this.end.add(toAdd);
    }

    public void render(GuiGraphics graphics, double mouseX, double mouseY) {
        ClientHelper.fill(graphics, this.start.x, this.start.y, this.end.x, this.end.y, this.color, -1);
    }

    public void moveX(float offset) {
        this.start = new Vec2(this.start.x + offset, this.start.y);
    }

    public void moveY(float offset) {
        this.start = new Vec2(this.start.x, this.start.y + offset);
    }
}

