/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.EntityAddedTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.ActivationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.TriggerInstance;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.ParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.EntityRemovedTerminatorTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTriggerInstance;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.kapitencraft.kap_lib.io.network.S2C.SendParticleAnimationPacket;
import net.minecraft.CrashReport;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

public class ParticleAnimation {
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleAnimation> CODEC = ExtraStreamCodecs.composite(AnimationElement.CODEC.apply(ByteBufCodecs.list()), ParticleAnimation::allElements, ParticleFinalizer.CODEC, p -> p.finalizer, TerminationTrigger.CODEC.apply(ByteBufCodecs.list()), ParticleAnimation::getTerminators, ActivationTrigger.CODEC.apply(ByteBufCodecs.list()), ParticleAnimation::getTriggers, Spawner.CODEC, p -> p.spawner, ByteBufCodecs.INT, p -> p.minSpawnDelay, ByteBufCodecs.INT, p -> p.maxSpawnDelay, ParticleAnimation::new);
    private final List<AnimationElement> elements;
    private final ParticleFinalizer finalizer;
    private final List<TerminationTriggerInstance> terminators;
    private final List<TriggerInstance> activationTriggers;
    private final Spawner spawner;
    public final int minSpawnDelay;
    public final int maxSpawnDelay;

    private ParticleAnimation(Builder builder) {
        if (builder.minSpawnDelay > builder.maxSpawnDelay) {
            throw new IllegalStateException("minimum spawn delay must be smaller than maximum spawn delay");
        }
        if (builder.minSpawnDelay < -1 || builder.minSpawnDelay == 0) {
            throw new IllegalStateException("minimum spawn delay must be above 0 or -1");
        }
        this.elements = builder.elements;
        this.finalizer = Objects.requireNonNull(builder.finalizer, "animations must have a finalizer");
        this.spawner = Objects.requireNonNull(builder.spawner, "animations must have a spawner");
        this.terminators = builder.terminators;
        if (this.terminators.isEmpty()) {
            throw new IllegalStateException("particle animation must have a terminator");
        }
        this.maxSpawnDelay = builder.maxSpawnDelay;
        this.minSpawnDelay = builder.minSpawnDelay;
        this.activationTriggers = builder.activationTriggers;
    }

    private ParticleAnimation(List<AnimationElement> elements, ParticleFinalizer finalizer, List<TerminationTriggerInstance> terminators, List<TriggerInstance> activationTriggers, Spawner spawner, int minSpawnDelay, int maxSpawnDelay) {
        this.elements = elements;
        this.finalizer = finalizer;
        this.terminators = terminators;
        this.spawner = spawner;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.activationTriggers = activationTriggers;
    }

    public AnimationElement getElement(int elementIndex) {
        return this.elements.get(elementIndex);
    }

    public List<AnimationElement> allElements() {
        return this.elements;
    }

    public List<TerminationTriggerInstance> getTerminators() {
        return this.terminators;
    }

    public void spawnTick(ParticleSpawnSink sink) {
        this.spawner.spawn(sink);
    }

    public List<TriggerInstance> getTriggers() {
        return this.activationTriggers;
    }

    public void fillCrashReport(CrashReport report) {
        report.addCategory("Animation").setDetail("Elements", this.elements).setDetail("Particle Finalizer", (Object)this.finalizer).setDetail("Terminator", this.terminators).setDetail("Activation Triggers", this.activationTriggers).setDetail("Spawner", (Object)this.spawner).setDetail("minSpawnDelay", (Object)this.minSpawnDelay).setDetail("maxSpawnDelay", (Object)this.maxSpawnDelay);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder requireEntity(Entity target) {
        return ParticleAnimation.builder().activatedOn(EntityAddedTrigger.forEntity(target)).terminatedWhen(EntityRemovedTerminatorTrigger.create(target));
    }

    @ApiStatus.Internal
    public void finalize(ParticleConfig config) {
        this.finalizer.finalize(config);
    }

    public static class Builder {
        private final List<AnimationElement> elements = new ArrayList<AnimationElement>();
        private Spawner spawner;
        private ParticleFinalizer finalizer;
        private final List<TerminationTriggerInstance> terminators = new ArrayList<TerminationTriggerInstance>();
        private int minSpawnDelay;
        private int maxSpawnDelay;
        private final List<TriggerInstance> activationTriggers = new ArrayList<TriggerInstance>();

        private Builder() {
        }

        public Builder spawn(Spawner.Builder spawn) {
            this.spawner = spawn.build();
            Preconditions.checkNotNull(this.spawner.getType(), (Object)"Spawner without Type detected!");
            return this;
        }

        private Builder minSpawnTickTime(int minTickTime) {
            this.minSpawnDelay = minTickTime;
            return this;
        }

        private Builder maxSpawnTickTime(int maxSpawnTickTime) {
            this.maxSpawnDelay = maxSpawnTickTime;
            return this;
        }

        public Builder spawnTime(SpawnTime time) {
            return this.minSpawnTickTime(time.min).maxSpawnTickTime(time.max);
        }

        public Builder finalizes(ParticleFinalizer.Builder finalizerBuilder) {
            this.finalizer = finalizerBuilder.build();
            Preconditions.checkNotNull(this.finalizer.getType(), (Object)"Finalizer without type detected!");
            return this;
        }

        public Builder terminatedWhen(TerminationTriggerInstance terminator) {
            Preconditions.checkNotNull(terminator.getTrigger(), (Object)"Terminator without type detected!");
            this.terminators.add(terminator);
            return this;
        }

        public Builder activatedOn(TriggerInstance activationListener) {
            Preconditions.checkNotNull(activationListener.getTrigger(), (Object)"Activation Listener without trigger detected!");
            this.activationTriggers.add(activationListener);
            return this;
        }

        public Builder then(AnimationElement.Builder builder) {
            this.elements.add(builder.build());
            return this;
        }

        @ApiStatus.Internal
        private ParticleAnimation build() {
            return new ParticleAnimation(this);
        }

        public void sendToPlayer(ServerPlayer player) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SendParticleAnimationPacket(this.build()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public void sendToAllPlayers() {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SendParticleAnimationPacket(this.build()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void register() {
            LibClient.animations.accept(this.build());
        }
    }

    public static class SpawnTime {
        private final int min;
        private final int max;

        public SpawnTime(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public static SpawnTime once() {
            return new SpawnTime(-1, -1);
        }

        public static SpawnTime absolute(int time) {
            return new SpawnTime(time, time);
        }

        public static SpawnTime range(int min, int max) {
            return new SpawnTime(min, max);
        }
    }
}

