/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import java.util.Objects;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MoveTowardsBBElement
implements AnimationElement {
    private final int entity;
    private final int duration;

    public MoveTowardsBBElement(int entity, int duration) {
        this.entity = entity;
        this.duration = duration;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Type getType() {
        return ElementTypes.MOVE_TOWARDS_BB.get();
    }

    @Override
    public int createLength(ParticleConfig config) {
        return this.duration;
    }

    @Override
    public void initialize(ParticleConfig object) {
        object.setProperty("target", MathHelper.randomIn(MathHelper.RANDOM_SOURCE, ClientHelper.getEntity(this.entity).getBoundingBox()).subtract(ClientHelper.getEntity(this.entity).position()));
        object.setProperty("origin", object.pos());
    }

    @Override
    public void tick(ParticleConfig object, int tick, double percentage) {
        object.setPos(((Vec3)object.getProperty("origin")).lerp(((Vec3)object.getProperty("target")).add(ClientHelper.getEntity(this.entity).position()), percentage));
    }

    public static class Builder
    implements AnimationElement.Builder {
        private Entity entity;
        private int duration;

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder target(Entity entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public AnimationElement build() {
            if (this.duration < 1) {
                throw new IllegalStateException("MoveTowardsBB duration must be larger than 0");
            }
            return new MoveTowardsBBElement(Objects.requireNonNull(this.entity, "MoveTowardsBB without entity found!").getId(), this.duration);
        }
    }

    public static class Type
    implements AnimationElement.Type<MoveTowardsBBElement> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, MoveTowardsBBElement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, e -> e.entity, (StreamCodec)ByteBufCodecs.INT, e -> e.duration, MoveTowardsBBElement::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, MoveTowardsBBElement> codec() {
            return STREAM_CODEC;
        }
    }
}

