/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.finalizers;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.ParticleFinalizer;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.FinalizerTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class SetLifeTimeFinalizer
implements ParticleFinalizer {
    private final int lifeTime;
    private final boolean resetAge;

    public SetLifeTimeFinalizer(int lifeTime, boolean resetAge) {
        this.lifeTime = lifeTime;
        this.resetAge = resetAge;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Type getType() {
        return FinalizerTypes.SET_LIFE_TIME.get();
    }

    @Override
    public void finalize(ParticleConfig config) {
        config.lifeTime = this.lifeTime;
        if (this.resetAge) {
            config.age = 0;
        }
    }

    public String toString() {
        return "SetLifeTimeFinalizer{lifeTime=" + this.lifeTime + (this.resetAge ? ", resetsAge" : "") + "}";
    }

    public static class Builder
    implements ParticleFinalizer.Builder {
        private int lifeTime;
        private boolean resetAge = false;

        public Builder resetAge() {
            this.resetAge = true;
            return this;
        }

        public Builder lifeTime(int lifeTime) {
            this.lifeTime = lifeTime;
            return this;
        }

        @Override
        public ParticleFinalizer build() {
            return new SetLifeTimeFinalizer(this.lifeTime, this.resetAge);
        }
    }

    public static class Type
    implements ParticleFinalizer.Type<SetLifeTimeFinalizer> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, SetLifeTimeFinalizer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, f -> f.lifeTime, (StreamCodec)ByteBufCodecs.BOOL, f -> f.resetAge, SetLifeTimeFinalizer::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, SetLifeTimeFinalizer> codec() {
            return STREAM_CODEC;
        }
    }
}

