/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record GroupSpawner(List<Spawner> spawners) implements Spawner
{
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        for (Spawner spawner : this.spawners) {
            spawner.spawn(sink);
        }
    }

    @NotNull
    public Type getType() {
        return SpawnerTypes.GROUP.get();
    }

    public static class Builder
    implements Spawner.Builder {
        private final List<Spawner> spawners = new ArrayList<Spawner>();

        public Builder addSpawner(Spawner.Builder spawner) {
            this.spawners.add(spawner.build());
            return this;
        }

        @Override
        public Spawner build() {
            return new GroupSpawner(this.spawners);
        }
    }

    public static class Type
    implements Spawner.Type<GroupSpawner> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, GroupSpawner> STREAM_CODEC = Spawner.CODEC.apply(ByteBufCodecs.list()).map(GroupSpawner::new, GroupSpawner::spawners);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, GroupSpawner> codec() {
            return STREAM_CODEC;
        }
    }
}

