/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class Checkbox
extends Button {
    private final boolean checkBoxLeft;
    boolean checked;

    public Checkbox(int pX, int pY, Component pMessage, boolean checkBoxLeft, Font font, boolean checked) {
        super(pX, pY, 12 + font.width((FormattedText)pMessage), 10, pMessage, pButton -> {}, Supplier::get);
        this.checkBoxLeft = checkBoxLeft;
        this.checked = checked;
    }

    protected boolean clicked(double pMouseX, double pMouseY) {
        return Math.abs(pMouseY - (double)this.getY()) <= 10.0 && this.checkBoxLeft ? Math.abs(pMouseX - (double)this.getX()) <= 10.0 : pMouseX - (double)this.getX() >= (double)(this.getWidth() - 10);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int checkBoxX = this.checkBoxLeft ? this.getX() : this.getX() + this.getWidth() - 10;
        int checkBoxY = this.getY();
        graphics.fill(checkBoxX, checkBoxY, checkBoxX + 10, checkBoxY + 10, -16777216);
        graphics.fill(checkBoxX + 1, checkBoxY + 1, checkBoxX + 9, checkBoxY + 9, -1);
        if (this.checked) {
            UsefulTextures.renderCheckMark(graphics, checkBoxX + 1, checkBoxY + 1);
        }
        int textX = this.checkBoxLeft ? this.getX() + 11 : this.getX() + this.getWidth() - 11;
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), textX, this.getY() + 1, -1);
    }

    public void onClick(double pMouseX, double pMouseY) {
        this.setChecked(!this.isChecked());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean wasChecked) {
        this.checked = wasChecked;
    }
}

