/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.math.MethodsReturnNonnullByDefault;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpawnTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<SpawnTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public SpawnTableProvider(PackOutput pOutput, Set<ResourceKey<SpawnTable>> pRequiredTables, List<SubProviderEntry> pSubProviders, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = pOutput.createPathProvider(PackOutput.Target.DATA_PACK, "kap_lib/spawn_tables");
        this.subProviders = pSubProviders;
        this.requiredTables = pRequiredTables;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(p -> this.run(pOutput, (HolderLookup.Provider)p));
    }

    public CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider provider) {
        MappedRegistry writableregistry = new MappedRegistry(ExtraRegistries.Keys.SPAWN_TABLES, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> SpawnTableProvider.lambda$run$2(provider, (Map)map, (WritableRegistry)writableregistry, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        HolderGetter.Provider holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze().asGetterLookup();
        ValidationContext validationcontext = new ValidationContext((ProblemReporter)problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        this.validate((WritableRegistry<SpawnTable>)writableregistry, validationcontext, problemreporter$collector);
        Multimap multimap = problemreporter$collector.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableregistry.entrySet().stream().map(p_335193_ -> {
            ResourceKey resourcekey1 = (ResourceKey)p_335193_.getKey();
            SpawnTable loottable = (SpawnTable)p_335193_.getValue();
            Path path = this.pathProvider.json(resourcekey1.location());
            return DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)provider, SpawnTable.DIRECT_CODEC, (Object)loottable, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(WritableRegistry<SpawnTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        for (ResourceKey spawnTableResourceKey : Sets.difference(this.requiredTables, (Set)writableregistry.registryKeySet())) {
            problemreporter$collector.report("Missing built-in table: " + String.valueOf(spawnTableResourceKey.location()));
        }
        writableregistry.holders().forEach(p_335195_ -> ((SpawnTable)p_335195_.value()).validate(validationcontext.setParams(((SpawnTable)p_335195_.value()).getParamSet()).enterElement("{" + String.valueOf(p_335195_.key().location()) + "}", p_335195_.key())));
    }

    @NotNull
    public final String getName() {
        return "Spawn Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider provider, Map map, WritableRegistry writableregistry, SubProviderEntry p_329847_) {
        p_329847_.provider().apply(provider).generate((p_335199_, p_335200_) -> {
            ResourceLocation resourcelocation = p_335199_.location();
            ResourceLocation resourcelocation1 = map.put(RandomSequence.seedForKey((ResourceLocation)resourcelocation), resourcelocation);
            if (resourcelocation1 != null) {
                String var10000 = String.valueOf(resourcelocation1);
                Util.logAndPauseIfInIde((String)("Loot table random sequence seed collision on " + var10000 + " and " + String.valueOf(p_335199_.location())));
            }
            p_335200_.setRandomSequence(resourcelocation);
            SpawnTable loottable = p_335200_.setParamSet(p_329847_.paramSet).build();
            writableregistry.register(p_335199_, (Object)loottable, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, SubProvider> provider, LootContextParamSet paramSet) {
    }

    @FunctionalInterface
    protected static interface SubProvider {
        public void generate(BiConsumer<ResourceKey<SpawnTable>, SpawnTable.Builder> var1);
    }
}

