/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst.recipe;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.crafting.serializers.ArmorRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorRecipeBuilder
implements RecipeBuilder {
    private final Map<ArmorItem.Type, ? extends DeferredItem<? extends Item>> items;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();
    private String group = "";
    private Ingredient material;

    private ArmorRecipeBuilder(Map<ArmorItem.Type, ? extends DeferredItem<? extends Item>> items) {
        this.items = items;
    }

    public static ArmorRecipeBuilder create(Map<ArmorItem.Type, ? extends DeferredItem<? extends Item>> items) {
        return new ArmorRecipeBuilder(items);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.advancement.addCriterion(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public RecipeBuilder material(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public RecipeBuilder material(Item item) {
        this.unlockedBy(ArmorRecipeBuilder.getHasName((ItemLike)item), ArmorRecipeBuilder.has((ItemLike)item));
        return this.material(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public RecipeBuilder material(DeferredItem<? extends Item> registryObject) {
        return this.material((Item)registryObject.get());
    }

    @NotNull
    public Item getResult() {
        return (Item)this.items.values().iterator().next().get();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        recipeOutput.accept(id, (Recipe)new ArmorRecipe(this.material, this.convert(this.items), this.group), this.advancement.build(id.withPrefix("recipes/")));
    }

    private Map<ArmorRecipe.ArmorType, ItemStack> convert(Map<ArmorItem.Type, ? extends DeferredItem<? extends Item>> items) {
        return MapStream.of(items).mapKeys(ArmorRecipe.ArmorType::fromEquipmentSlot).mapValues(DeferredItem::asItem).mapValues(ItemStack::new).toMap();
    }

    protected static String getHasName(ItemLike pItemLike) {
        return "has_" + ArmorRecipeBuilder.getItemName(pItemLike);
    }

    protected static String getItemName(ItemLike pItemLike) {
        return BuiltInRegistries.ITEM.getKey((Object)pItemLike.asItem()).getPath();
    }

    protected static Criterion<?> has(ItemLike pItemLike) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)ArmorRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{pItemLike}).build()));
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... pPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of(pPredicates));
    }
}

