/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import java.util.Optional;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.tags.ExtraTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;

public class EnchantmentHelperExtras {
    public static Enchantment.Builder ultimate(HolderGetter<Enchantment> enchantments, Enchantment.EnchantmentDefinition definition) {
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)definition).exclusiveWith((HolderSet)enchantments.getOrThrow(ExtraTags.Enchantments.ULTIMATE));
    }

    public static Enchantment.EnchantmentDefinition bow(HolderGetter<Item> items, int weight, int maxLevel, Enchantment.Cost minCost, Enchantment.Cost maxCost, int anvilCost) {
        return Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.BOW_ENCHANTABLE), (int)weight, (int)maxLevel, (Enchantment.Cost)minCost, (Enchantment.Cost)maxCost, (int)anvilCost, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND});
    }

    public static int repairPlayerItems(@NotNull Player player, int value, @NotNull DataComponentType<?> ench) {
        Optional entry = EnchantmentHelper.getRandomItemWith(ench, (LivingEntity)player, ItemStack::isDamaged);
        if (entry.isPresent()) {
            ItemStack itemstack = ((EnchantedItemInUse)entry.get()).itemStack();
            int i = Math.min((int)((float)value * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
            itemstack.setDamageValue(itemstack.getDamageValue() - i);
            int j = value - i / 2;
            return j > 0 ? EnchantmentHelperExtras.repairPlayerItems(player, j, ench) : 0;
        }
        return value;
    }

    public static void getEnchantmentLevelAndDo(ItemStack stack, Holder<Enchantment> enchantment, Consumer<Integer> enchConsumer) {
        if (stack.getEnchantmentLevel(enchantment) > 0) {
            enchConsumer.accept(stack.getEnchantmentLevel(enchantment));
        }
    }

    public static void getEnchantmentLevelAndDo(RegistryAccess access, ItemStack stack, ResourceKey<Enchantment> key, Consumer<Integer> enchConsumer) {
        EnchantmentHelperExtras.getEnchantmentLevelAndDo(stack, (Holder<Enchantment>)access.holderOrThrow(key), enchConsumer);
    }

    public static void getEnchantmentLevelAndDo(LivingEntity entity, Holder<Enchantment> enchantmentHolder, Consumer<Integer> enchConsumer) {
        int level = EnchantmentHelper.getEnchantmentLevel(enchantmentHolder, (LivingEntity)entity);
        if (level > 0) {
            enchConsumer.accept(level);
        }
    }

    public static void getEnchantmentLevelAndDo(LivingEntity living, ResourceKey<Enchantment> key, Consumer<Integer> enchConsumer) {
        EnchantmentHelperExtras.getEnchantmentLevelAndDo(living, (Holder<Enchantment>)living.registryAccess().holderOrThrow(key), enchConsumer);
    }
}

