/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MathHelper {
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final double DAMAGE_CALCULATION_VALUE = 50.0;

    public static int ARGBtoInt(int a, int r, int g, int b) {
        int returnable = (a << 8) + r;
        returnable = (returnable << 8) + g;
        return (returnable << 8) + b;
    }

    public static IntSet intSetRange(int min, int max) {
        int[] range = new int[max - min + 1];
        for (int i = min; i <= max; ++i) {
            range[i - min] = min + i;
        }
        return IntSet.of((int[])range);
    }

    public static Vec2 normal(Vec2 og) {
        return new Vec2(og.x, -og.y);
    }

    public static double round(double no, int num) {
        return Math.floor(no * Math.pow(10.0, num)) / Math.pow(10.0, num);
    }

    public static double defRound(double no) {
        return MathHelper.round(no, 2);
    }

    public static double shortRound(double no) {
        return MathHelper.round(no, 1);
    }

    public static float calculateDamage(float damage, double armorValue, double armorToughnessValue) {
        double f = 50.0 - armorToughnessValue / 4.0;
        double defencePercentage = armorValue / (armorValue + f);
        return (float)((double)damage * (1.0 - defencePercentage));
    }

    public static Vec3 getHandHoldingItemAngle(HumanoidArm arm, @NotNull Entity entity) {
        return entity.position().add(entity.calculateViewVector(0.0f, entity.getYRot() + (float)(arm == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5));
    }

    public static Vec3 rotateXAxis(@NotNull Vec3 source, Vec3 pivot, float angle) {
        double y = (source.y - pivot.y) * (double)Mth.cos((float)angle) - (source.z - pivot.z) * (double)Mth.sin((float)angle) + pivot.y;
        double z = (source.y - pivot.y) * (double)Mth.sin((float)angle) + (source.z - pivot.z) * (double)Mth.cos((float)angle) + pivot.z;
        return new Vec3(source.x, y, z);
    }

    public static Vec3 rotateHorizontalYAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle) {
        double x = (source.x - pivot.x) * (double)Mth.cos((float)angle) - (source.z - pivot.z) * (double)Mth.sin((float)angle) + pivot.x;
        double z = (source.x - pivot.x) * (double)Mth.sin((float)angle) + (source.z - pivot.z) * (double)Mth.cos((float)angle) + pivot.z;
        return new Vec3(x, source.y, z);
    }

    public static Vec3 rotateZAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle) {
        double x = (source.x - pivot.x) * (double)Mth.cos((float)angle) - (source.y - pivot.y) * (double)Mth.sin((float)angle) + pivot.x;
        double y = (source.x - pivot.x) * (double)Mth.sin((float)angle) + (source.y - pivot.y) * (double)Mth.cos((float)angle) + pivot.y;
        return new Vec3(x, y, source.z);
    }

    public static Vec3 rotateAroundAxis(@NotNull Vec3 source, @NotNull Vec3 pivot, float angle, @NotNull Direction.Axis axis) {
        angle *= (float)Math.PI / 180;
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> MathHelper.rotateXAxis(source, pivot, angle);
            case Direction.Axis.Y -> MathHelper.rotateHorizontalYAxis(source, pivot, angle);
            case Direction.Axis.Z -> MathHelper.rotateZAxis(source, pivot, angle);
        };
    }

    public static boolean isBetween(double val, int start, int end) {
        return Mth.clamp((double)val, (double)start, (double)end) == val;
    }

    public static boolean isBetween(double val, double start, double end) {
        return Mth.clamp((double)val, (double)start, (double)end) == val;
    }

    public static boolean is2dBetween(double xVal, double yVal, int xStart, int yStart, int xEnd, int yEnd) {
        return MathHelper.isBetween(xVal, xStart, xEnd) && MathHelper.isBetween(yVal, yStart, yEnd);
    }

    public static int getLargest(@NotNull Collection<Integer> floats) {
        return floats.stream().mapToInt(i -> i).max().orElse(0);
    }

    @Contract(value="_, _ -> new")
    public static Predicate<String> checkForInteger(int min, int max) {
        return s -> {
            try {
                int num = Integer.parseInt(s);
                return num >= min && num <= max;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Entity source, double range) {
        Level level = source.level();
        return MathHelper.getEntitiesAround(tClass, level, source.getBoundingBox(), range);
    }

    @Contract(value="_, null, _ -> fail; null, _, _ -> fail")
    public static void add(Supplier<Integer> getter, Consumer<Integer> setter, int change) {
        setter.accept(getter.get() + change);
    }

    public static void up1(Reference<Integer> reference) {
        MathHelper.add(reference::getIntValue, reference::setValue, 1);
    }

    public static void mul(Supplier<Integer> getter, Consumer<Integer> setter, int mul) {
        setter.accept(getter.get() * mul);
    }

    public static void mul(Supplier<Double> getter, Consumer<Double> setter, double mul) {
        setter.accept(getter.get() * mul);
    }

    public static void mul(Supplier<Float> getter, Consumer<Float> setter, float mul) {
        setter.accept(Float.valueOf(getter.get().floatValue() * mul));
    }

    @Contract(value="null, _, _ -> fail; _, _, _ -> new")
    public static ArrayList<Vec3> lineOfSight(Entity entity, double range, double scaling) {
        Vec3 viewVec = entity.calculateViewVector(entity.getXRot(), entity.getYRot());
        Vec3 viewVecWithLoc = viewVec.add(entity.getEyePosition());
        Vec3 end = viewVec.scale(range).add(entity.getEyePosition());
        BlockHitResult result = entity.level().clip(new ClipContext(viewVecWithLoc, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        Vec3 diff = result.getLocation().subtract(viewVecWithLoc);
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        int i = 0;
        while ((double)i < diff.length() / scaling) {
            list.add(MathHelper.clampLength(diff, (double)i * scaling).add(entity.getEyePosition()));
            ++i;
        }
        return list;
    }

    public static ArrayList<Vec3> lineOfSight(Vec2 vec, Vec3 pos, double range, double scaling) {
        ArrayList<Vec3> line = new ArrayList<Vec3>();
        for (double i = 0.0; i <= range; i += scaling) {
            Vec3 vec3 = MathHelper.calculateViewVector(vec.x, vec.y).scale(i).add(pos.x, pos.y, pos.z);
            line.add(vec3);
        }
        return line;
    }

    public static int count(@NotNull Collection<Integer> collection) {
        int count = 0;
        for (Integer integer : collection) {
            count += integer.intValue();
        }
        return count;
    }

    public static List<BlockPos> makeLine(BlockPos a, BlockPos b, LineSize size) {
        BlockPos diff = b.subtract((Vec3i)a);
        double horizontal = Mth.sqrt((float)(diff.getX() * diff.getX() + diff.getZ() * diff.getZ() + diff.getY() * diff.getY()));
        int numPoints = (int)(size == LineSize.THIN ? horizontal * 20.0 : horizontal * 50.0);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        MiscHelper.repeat(numPoints, integer -> {
            double t = (double)integer.intValue() / ((double)numPoints - 1.0);
            list.add(MathHelper.makeLinePos(t, a, diff));
        });
        return list;
    }

    private static BlockPos makeLinePos(double t, BlockPos a, BlockPos diff) {
        return new BlockPos((int)((double)a.getX() + (double)diff.getX() * t), (int)((double)a.getY() + (double)diff.getY() * t), (int)((double)a.getZ() + (double)diff.getZ() * t));
    }

    public static List<Vec3> makeLine(Vec3 a, Vec3 b, float spacing) {
        Vec3 diff = b.subtract(a);
        int numPoints = (int)(diff.length() / (double)spacing);
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        MiscHelper.repeat(numPoints, integer -> {
            double t = (double)integer.intValue() / ((double)numPoints - 1.0);
            list.add(a.add(diff.scale(t)));
        });
        return list;
    }

    public static <T> boolean validIndex(List<T> values, int selectedIndex) {
        return MathHelper.isBetween((double)selectedIndex, 0, values.size() - 1);
    }

    public static Vec3 withRoll(Vec2 rotation, float roll) {
        return new Vec3((double)rotation.x, (double)rotation.y, (double)roll);
    }

    public static Vec3 moveTowards(Vec3 source, Vec3 target, double range, boolean percentage) {
        Vec3 change = source.subtract(target);
        double dist = source.distanceTo(target);
        return percentage ? MathHelper.clampLength(change, dist * range) : MathHelper.clampLength(change, range);
    }

    @Nullable
    public static <T> T pickRandom(@NotNull List<T> list) {
        return MathHelper.pickRandom(list, RANDOM_SOURCE);
    }

    public static <T> T pickRandom(@NotNull List<T> list, @NotNull RandomSource source) {
        return list.isEmpty() ? null : (T)list.get(Mth.nextInt((RandomSource)source, (int)0, (int)(list.size() - 1)));
    }

    public static boolean chance(double baseChance, @Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return MathHelper.chance(baseChance, living);
        }
        return MathHelper.chance(baseChance, null);
    }

    public static boolean chance(double chance, @Nullable LivingEntity living) {
        return Math.random() <= chance * (living != null ? 1.0 + living.getAttributeValue(Attributes.LUCK) / 100.0 : 1.0);
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Level level, AABB source, double range) {
        return level.getEntitiesOfClass(tClass, source.inflate(range));
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(Class<T> tClass, Entity source, double range) {
        List<Entity> entities = MathHelper.getEntitiesAround(tClass, source, range).stream().filter(t -> t.is(source)).sorted(Comparator.comparingDouble(value -> value.distanceTo(source))).toList();
        if (entities.isEmpty()) {
            return null;
        }
        return (T)entities.getFirst();
    }

    public static LivingEntity getClosestLiving(Entity source, double range) {
        return MathHelper.getClosestEntity(LivingEntity.class, source, range);
    }

    public static List<LivingEntity> getLivingAround(Entity source, double range) {
        return MathHelper.getEntitiesAround(LivingEntity.class, source, range);
    }

    public static Vec3 calculateViewVector(float horizontalHeightXAxis, float verticalYAxis) {
        float f = horizontalHeightXAxis * ((float)Math.PI / 180);
        float f1 = -verticalYAxis * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static <T extends Entity> List<T> getAllEntitiesInsideCone(Class<T> tClass, float span, double range, Vec3 sourcePos, Vec2 sourceRot, Level level) {
        double halfSpan = span / 2.0f;
        double incremental = Math.sin(halfSpan) * 0.1;
        ArrayList<Vec3> lineOfSight = MathHelper.lineOfSight(sourceRot, sourcePos, range, 0.1);
        ArrayList toReturn = new ArrayList();
        lineOfSight.stream().collect(CollectorHelper.createMapForKeys(lineOfSight::indexOf)).forEach((integer, vec3) -> toReturn.addAll(MathHelper.getEntitiesAround(tClass, level, vec3, incremental * (double)integer.intValue()).stream().filter(entity -> !toReturn.contains(entity)).toList()));
        return toReturn;
    }

    public static <T extends Entity> List<T> getEntitiesAround(Class<T> tClass, Level level, Vec3 loc, double range) {
        return level.getEntitiesOfClass(tClass, new AABB(loc.x - range, loc.y - range, loc.z - range, loc.x + range, loc.y + range, loc.z + range));
    }

    public static List<Entity> getAllEntitiesInsideCylinder(float radius, Vec3 sourcePos, Vec2 rot, double range, Level level) {
        ArrayList<Entity> toReturn = new ArrayList<Entity>();
        ArrayList<Vec3> lineOfSight = MathHelper.lineOfSight(rot, sourcePos, range, 0.1);
        lineOfSight.forEach(vec3 -> {
            List<Entity> entities = MathHelper.getEntitiesAround(Entity.class, level, vec3, (double)radius);
            toReturn.addAll(entities.stream().filter(entity -> !toReturn.contains(entity)).toList());
        });
        return toReturn;
    }

    public static Vec2 createTargetRotation(Entity source, Entity target) {
        return MathHelper.createTargetRotationFromPos(source.position(), target.position());
    }

    public static Vec2 createTargetRotationFromPos(@NotNull Vec3 source, @NotNull Vec3 target) {
        double dX = target.x - source.x;
        double dY = target.y - source.y;
        double dZ = target.z - source.z;
        double d3 = Math.sqrt(dX * dX + dZ * dZ);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)dY, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875) - 90.0f)));
    }

    public static Vec2 createTargetRotationFromEyeHeight(Entity source, Entity target) {
        return MathHelper.createTargetRotationFromPos(source.getEyePosition(), target.getEyePosition());
    }

    public static boolean isBehind(Entity source, Entity target) {
        Vec3 vec32 = source.position();
        Vec3 vec31 = vec32.vectorTo(target.position()).normalize();
        vec31 = new Vec3(vec31.x, 0.0, vec31.z);
        return !(vec31.dot(target.getViewVector(1.0f)) < 0.0);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 minimiseLength(Vec3 source, double minimum) {
        if (source.length() > minimum) {
            return source;
        }
        double scale = minimum / source.length();
        return source.scale(scale);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 maximiseLength(Vec3 source, double maximum) {
        if (source.length() < maximum) {
            return source;
        }
        double scale = maximum / source.length();
        return source.scale(scale);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 clampLength(Vec3 source, double value) {
        if (source.length() > value) {
            return MathHelper.maximiseLength(source, value);
        }
        return MathHelper.minimiseLength(source, value);
    }

    public static Vec3 getRandomOffsetForPos(Entity target, double dist, double maxOffset) {
        RandomSource source = RandomSource.create();
        Vec2 rot = target.getRotationVector();
        Vec3 targetPos = MathHelper.calculateViewVector(rot.x, rot.y).scale(dist);
        Vec3 secPos = MathHelper.removeByScale(MathHelper.calculateViewVector(rot.x - 90.0f, rot.y).scale((maxOffset *= 2.0) * (double)source.nextFloat()), 0.5);
        Vec3 thirdPos = MathHelper.removeByScale(MathHelper.calculateViewVector(rot.x, rot.y - 90.0f).scale(maxOffset * (double)source.nextFloat()), 0.5);
        return targetPos.add(secPos).add(thirdPos);
    }

    @Contract(value="null, _ -> fail")
    public static Vec3 removeByScale(Vec3 vec3, double scale) {
        double x = vec3.x;
        double y = vec3.y;
        double z = vec3.z;
        double halfX = x - x * scale;
        double halfY = y - y * scale;
        double halfZ = z - z * scale;
        return new Vec3(halfX, halfY, halfZ);
    }

    public static float randomBetween(RandomSource source, float min, float max) {
        return Mth.lerp((float)source.nextFloat(), (float)min, (float)max);
    }

    public static double randomBetween(RandomSource source, double min, double max) {
        return Mth.lerp((double)source.nextDouble(), (double)min, (double)max);
    }

    public static Vec3 randomBetween(RandomSource source, Vec3 min, Vec3 max) {
        return new Vec3(MathHelper.randomBetween(source, min.x, max.x), MathHelper.randomBetween(source, min.y, max.y), MathHelper.randomBetween(source, min.z, max.z));
    }

    public static Vec3 randomIn(RandomSource source, AABB box) {
        return new Vec3(MathHelper.randomBetween(source, box.minX, box.maxX), MathHelper.randomBetween(source, box.minY, box.maxY), MathHelper.randomBetween(source, box.minZ, box.maxZ));
    }

    public static float getOversizeScale(Vec3 original, Vec3 clamped) {
        if (clamped.equals((Object)original)) {
            return 1.0f;
        }
        float x = original.x == 0.0 ? 0.0f : (float)(original.x / clamped.x);
        float y = original.y == 0.0 ? 0.0f : (float)(original.y / clamped.y);
        float z = original.z == 0.0 ? 0.0f : (float)(original.z / clamped.z);
        return MathHelper.pickLargest(x, y, z);
    }

    public static float pickLargest(float ... values) {
        Float min = null;
        for (float f : values) {
            if (min != null && !(min.floatValue() < f)) continue;
            min = Float.valueOf(f);
        }
        return min == null ? -1.0f : min.floatValue();
    }

    public static BlockPos randomOffset(BlockPos pivot, RandomSource source) {
        int random = source.nextIntBetweenInclusive(0, 8);
        if (random > 2) {
            ++random;
        }
        int xOffset = random / 3 - 1;
        int zOffset = random % 3 - 1;
        return pivot.offset(xOffset, 0, zOffset);
    }

    public static enum LineSize {
        THIN,
        THICK;

    }
}

