/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.creative_tab;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;

public class TabGroup {
    private static final List<TabGroup> groups = new ArrayList<TabGroup>();
    protected final Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>[] types;
    protected final List<DeferredItem<? extends Item>> items = new ArrayList<DeferredItem<? extends Item>>();

    @SafeVarargs
    public TabGroup(Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>> ... type) {
        this.types = type;
        groups.add(this);
    }

    public TabGroup add(DeferredItem<? extends Item> toAdd) {
        this.items.add(toAdd);
        return this;
    }

    public void register(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        for (Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>> pair : this.types) {
            if (!((ResourceKey)pair.getSecond()).equals(tabKey)) continue;
            Either position = (Either)pair.getFirst();
            if (position == null) {
                for (DeferredItem<? extends Item> item : this.items) {
                    event.accept(new ItemStack((ItemLike)item.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
                break;
            }
            position.ifRight(itemSupplier -> {
                ItemStack stack = new ItemStack((ItemLike)itemSupplier.get());
                for (DeferredItem<? extends Item> item : this.items) {
                    event.insertAfter(stack, new ItemStack((ItemLike)item.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }).ifLeft(itemSupplier -> {
                ItemStack stack = new ItemStack((ItemLike)itemSupplier.get());
                for (DeferredItem<? extends Item> item : this.items) {
                    event.insertBefore(stack, new ItemStack((ItemLike)item.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            });
        }
    }

    public static void registerAll(BuildCreativeModeTabContentsEvent event) {
        groups.forEach(group -> group.register(event));
    }

    public static TabGroup create(Holder<CreativeModeTab> obj) {
        return TabGroup.builder().tab(obj).build();
    }

    public static TabGroup create(ResourceKey<CreativeModeTab> key) {
        return TabGroup.builder().tab(key).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>> keys = new ArrayList<Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>>();

        private Builder() {
        }

        public Builder tab(ResourceKey<CreativeModeTab> key) {
            this.keys.add((Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>)Pair.of(null, key));
            return this;
        }

        public Builder tabAfter(Supplier<Item> after, ResourceKey<CreativeModeTab> key) {
            this.keys.add((Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>)Pair.of((Object)Either.right(after), key));
            return this;
        }

        public Builder tabBefore(Supplier<Item> before, ResourceKey<CreativeModeTab> key) {
            this.keys.add((Pair<Either<Supplier<Item>, Supplier<Item>>, ResourceKey<CreativeModeTab>>)Pair.of((Object)Either.left(before), key));
            return this;
        }

        public Builder tab(Holder<CreativeModeTab> tab) {
            return this.tab((ResourceKey<CreativeModeTab>)tab.getKey());
        }

        public Builder tabAfter(Supplier<Item> after, Holder<CreativeModeTab> value) {
            return this.tabAfter(after, (ResourceKey<CreativeModeTab>)value.getKey());
        }

        public Builder tabBefore(Supplier<Item> before, Holder<CreativeModeTab> value) {
            return this.tabBefore(before, (ResourceKey<CreativeModeTab>)value.getKey());
        }

        public TabGroup build() {
            return new TabGroup((Pair[])this.keys.toArray(Pair[]::new));
        }
    }
}

