/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import net.kapitencraft.kap_lib.helpers.LootTableHelper;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.AddItemModifier;
import net.kapitencraft.kap_lib.util.string_converter.converter.TextToDoubleConverter;
import net.kapitencraft.kap_lib.util.string_converter.param_storage.ParamStorage;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class EnchantmentAddItemModifier
extends AddItemModifier {
    public static final MapCodec<EnchantmentAddItemModifier> CODEC = RecordCodecBuilder.mapCodec(enchantmentAddItemModifierInstance -> EnchantmentAddItemModifier.addItemCodecStart(enchantmentAddItemModifierInstance).and((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(i -> i.enchantment)).and((App)Codec.STRING.fieldOf("provider").forGetter(i -> i.converter.getArgs())).apply((Applicative)enchantmentAddItemModifierInstance, EnchantmentAddItemModifier::new));
    private final Holder<Enchantment> enchantment;
    private final TextToDoubleConverter converter;

    protected EnchantmentAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance, int maxAmount, Optional<DataComponentPatch> tag, Holder<Enchantment> enchantment, String provider) {
        super(conditionsIn, item, chance, maxAmount, tag.orElse(null));
        this.converter = new TextToDoubleConverter(provider);
        this.enchantment = enchantment;
    }

    @Override
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack;
        LivingEntity entity = LootTableHelper.getLivingSource(context);
        ItemStack itemStack = stack = entity == null ? null : entity.getMainHandItem();
        if (stack != null) {
            double enchLevel = stack.getEnchantmentLevel(this.enchantment);
            this.addItem(arg_0 -> generatedLoot.add(arg_0), context, (float)((double)this.chance * this.converter.transfer(new ParamStorage<Double>(Map.of("ench", enchLevel)))));
        }
        return generatedLoot;
    }
}

