/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.kapitencraft.kap_lib.io.serialization.RegistrySerializer;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.CountCondition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class StatReqCondition
extends CountCondition<StatReqCondition> {
    private static final Map<StatType<?>, Function<?, Component>> STATS_TO_NAME_MAPPER = StatReqCondition.createStats();
    protected static final Codec<Stat<?>> STAT_CODEC = Codec.STRING.xmap(StatReqCondition::getStatFromSerializedName, StatReqCondition::getStatSerializedName);
    private static final MapCodec<StatReqCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)STAT_CODEC.fieldOf("stat").forGetter(StatReqCondition::getStat), (App)Codec.INT.fieldOf("minCount").forGetter(rec$ -> ((StatReqCondition)rec$).getMinLevel())).apply((Applicative)instance, StatReqCondition::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, StatReqCondition> STREAM_CODEC = StreamCodec.of(StatReqCondition::toNetwork, StatReqCondition::fromNetwork);
    public static final RegistrySerializer<StatReqCondition> SERIALIZER = new RegistrySerializer<StatReqCondition>(CODEC, STREAM_CODEC);
    protected final Stat<?> stat;

    public static ToIntFunction<LivingEntity> createCountExtractor(Stat<?> stat) {
        return value -> {
            int n;
            if (!(value instanceof Player)) {
                n = -1;
            } else if (value instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)value;
                n = sP.getStats().getValue(stat);
            } else {
                n = ((LocalPlayer)value).getStats().getValue(stat);
            }
            return n;
        };
    }

    private static Map<StatType<?>, Function<?, Component>> createStats() {
        HashMap map = new HashMap();
        StatReqCondition.appendStat(map, Stats.BLOCK_MINED, Block::getName);
        StatReqCondition.appendStat(map, Stats.ITEM_USED, Item::getDescription);
        StatReqCondition.appendStat(map, Stats.ITEM_PICKED_UP, Item::getDescription);
        StatReqCondition.appendStat(map, Stats.ITEM_CRAFTED, Item::getDescription);
        StatReqCondition.appendStat(map, Stats.ENTITY_KILLED, EntityType::getDescription);
        return map;
    }

    private static <T> void appendStat(Map<StatType<?>, Function<?, Component>> map, StatType<T> stat, Function<T, Component> mapper) {
        map.put(stat, mapper);
    }

    private static <T> Component readComponent(Stat<?> stat, StatType<?> type, Function<?, Component> mapper) {
        return StatReqCondition.createComponent(stat, type, mapper);
    }

    private static <T> Component createComponent(Stat<?> stat, StatType<T> otherType, Function<T, Component> mapper) {
        StatType type = stat.getType();
        if (type == otherType) {
            Object t = stat.getValue();
            return mapper.apply(t);
        }
        return null;
    }

    private static <T> String getStatSerializedName(Stat<T> stat) {
        return Stat.buildName((StatType)stat.getType(), (Object)stat.getValue());
    }

    private static <T> Stat<T> getStatFromSerializedName(String statName) {
        String[] split = statName.split(":");
        ResourceLocation statTypeLoc = ResourceLocation.bySeparator((String)split[0], (char)'.');
        StatType type = (StatType)BuiltInRegistries.STAT_TYPE.get(statTypeLoc);
        if (type == null) {
            throw new IllegalArgumentException("stat type '" + String.valueOf(statTypeLoc) + "' does not exist");
        }
        ResourceLocation statElementLoc = ResourceLocation.bySeparator((String)split[1], (char)'.');
        Object value = type.getRegistry().get(statElementLoc);
        if (value == null) {
            throw new IllegalArgumentException("stat element '" + String.valueOf(statElementLoc) + "' does not exist");
        }
        return type.get(value);
    }

    public StatReqCondition(Stat<?> stat, int level) {
        super(StatReqCondition.createCountExtractor(stat), level);
        this.stat = stat;
    }

    private <T> Component forStatType(Stat<T> stat) {
        StatType type = stat.getType();
        return StatReqCondition.readComponent(stat, type, STATS_TO_NAME_MAPPER.get(type));
    }

    @Override
    public RegistrySerializer<StatReqCondition> getSerializer() {
        return SERIALIZER;
    }

    private static void toNetwork(FriendlyByteBuf buf, StatReqCondition condition) {
        buf.writeUtf(StatReqCondition.getStatSerializedName(condition.stat));
        buf.writeInt(condition.minLevel);
    }

    public static StatReqCondition fromNetwork(FriendlyByteBuf buf) {
        return new StatReqCondition(StatReqCondition.getStatFromSerializedName(buf.readUtf()), buf.readInt());
    }

    private Stat<?> getStat() {
        return this.stat;
    }

    @Override
    public Component getCountedDisplay() {
        return Component.translatable((String)("stat_req." + this.getTranslationKey()), (Object[])new Object[]{this.minLevel, this.forStatType(this.stat)});
    }

    private String getTranslationKey() {
        return Objects.requireNonNull(BuiltInRegistries.STAT_TYPE.getKey((Object)this.stat.getType()), "unknown stat type: " + this.stat.getType().getClass().getCanonicalName()).toString().replace(':', '.');
    }
}

