/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.type;

import com.mojang.serialization.Codec;
import net.kapitencraft.kap_lib.io.serialization.DataPackSerializer;
import net.kapitencraft.kap_lib.requirements.type.RegistryHolderReqType;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.NotNull;

public class RegistryReqType<T>
implements RequirementType<T> {
    private final DataPackSerializer<T> serializer;
    private final String name;

    public static <T> RegistryReqType<T> registry(String name, Registry<T> registry, ResourceKey<Registry<T>> resourceKey) {
        return new RegistryReqType<T>(name, registry.byNameCodec(), resourceKey);
    }

    public static <T> RegistryHolderReqType<T> registryHolder(String name, ResourceKey<Registry<T>> resourceKey) {
        return new RegistryHolderReqType<T>(name, resourceKey);
    }

    public RegistryReqType(String name, Codec<T> codec, ResourceKey<Registry<T>> registry) {
        this.serializer = new DataPackSerializer<T>(codec, ByteBufCodecs.registry(registry));
        this.name = name;
    }

    @Override
    @NotNull
    public DataPackSerializer<T> serializer() {
        return this.serializer;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

