/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CommonPropertiesFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<CommonPropertiesFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.listOf().fieldOf("properties").forGetter(CommonPropertiesFunction::gatherProperties)).and(CommonPropertiesFunction.commonFields(i).t1()).apply((Applicative)i, CommonPropertiesFunction::new));
    private final boolean noGravity;
    private final boolean silent;
    private final boolean invulnerable;
    private final boolean glowing;

    protected CommonPropertiesFunction(List<String> properties, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        boolean noGravity = false;
        boolean silent = false;
        boolean invulnerable = false;
        boolean glowing = false;
        Iterator<String> iterator = properties.iterator();
        block12: while (iterator.hasNext()) {
            String s;
            switch (s = iterator.next()) {
                case "noGravity": {
                    noGravity = true;
                    continue block12;
                }
                case "silent": {
                    silent = true;
                    continue block12;
                }
                case "invulnerable": {
                    invulnerable = true;
                    continue block12;
                }
                case "glowing": {
                    glowing = true;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("unknown property: " + s);
        }
        this.noGravity = noGravity;
        this.silent = silent;
        this.invulnerable = invulnerable;
        this.glowing = glowing;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (this.noGravity) {
            pEntity.setNoGravity(true);
        }
        if (this.silent) {
            pEntity.setSilent(true);
        }
        if (this.invulnerable) {
            pEntity.setInvulnerable(true);
        }
        if (this.glowing) {
            pEntity.setGlowingTag(true);
        }
        return null;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.COMMON_PROPERTIES.get();
    }

    private List<String> gatherProperties() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.noGravity) {
            l.add("noGravity");
        }
        if (this.silent) {
            l.add("silent");
        }
        if (this.invulnerable) {
            l.add("invulnerable");
        }
        if (this.glowing) {
            l.add("glowing");
        }
        return l;
    }
}

