/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec2;

public class SetFacingFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<SetFacingFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(f -> Float.valueOf(f.rot.x)), (App)Codec.FLOAT.fieldOf("yaw").forGetter(f -> Float.valueOf(f.rot.y))).and(SetFacingFunction.commonFields(i).t1()).apply((Applicative)i, SetFacingFunction::fromCodec));
    private final Vec2 rot;

    private static SetFacingFunction fromCodec(float pitch, float yaw, List<LootItemCondition> lootItemConditions) {
        return new SetFacingFunction(lootItemConditions, new Vec2(pitch, yaw));
    }

    protected SetFacingFunction(List<LootItemCondition> pPredicates, Vec2 rot) {
        super(pPredicates);
        this.rot = rot;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        pEntity.setXRot(this.rot.x);
        pEntity.setYRot(this.rot.y);
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.SET_FACING.get();
    }
}

