/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;

public class VillagerPropertiesFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<VillagerPropertiesFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.VILLAGER_TYPE.byNameCodec().optionalFieldOf("biomeType").forGetter(f -> Optional.ofNullable(f.type)), (App)BuiltInRegistries.VILLAGER_PROFESSION.byNameCodec().optionalFieldOf("profession").forGetter(f -> Optional.ofNullable(f.profession)), (App)Codec.INT.optionalFieldOf("level", (Object)0).forGetter(f -> f.level)).and(VillagerPropertiesFunction.commonFields(i).t1()).apply((Applicative)i, VillagerPropertiesFunction::fromCodec));
    @Nullable
    private final VillagerType type;
    @Nullable
    private final VillagerProfession profession;
    @Nullable
    private final Integer level;

    private static VillagerPropertiesFunction fromCodec(Optional<VillagerType> villagerType, Optional<VillagerProfession> villagerProfession, int level, List<LootItemCondition> lootItemConditions) {
        return new VillagerPropertiesFunction(lootItemConditions, villagerType.orElse(null), villagerProfession.orElse(null), level);
    }

    protected VillagerPropertiesFunction(List<LootItemCondition> pPredicates, @Nullable VillagerType type, @Nullable VillagerProfession profession, @Nullable Integer level) {
        super(pPredicates);
        this.type = type;
        this.profession = profession;
        this.level = level;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof Villager) {
            Villager villager = (Villager)pEntity;
            VillagerData data = villager.getVillagerData();
            if (this.type != null) {
                data = data.setType(this.type);
            }
            if (this.profession != null) {
                data = data.setProfession(this.profession);
            }
            if (this.level != null) {
                data = data.setLevel(this.level.intValue());
            }
            villager.setVillagerData(data);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.VILLAGER_PROPERTIES.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private VillagerType type;
        private VillagerProfession profession;
        private Integer level;

        public Builder setType(VillagerType type) {
            this.type = type;
            return this;
        }

        public Builder setProfession(VillagerProfession profession) {
            this.profession = profession;
            return this;
        }

        public Builder setLevel(int level) {
            this.level = level;
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new VillagerPropertiesFunction(this.getConditions(), this.type, this.profession, this.level);
        }
    }
}

