/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kapitencraft.kap_lib.KapLibMod;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface UsefulTextures {
    public static final ResourceLocation CHECK_MARK = UsefulTextures.getGuiLocation("checkmark.png");
    public static final ResourceLocation CROSS = KapLibMod.res("textures/gui/red_cross.png");
    public static final ResourceLocation SLOT = KapLibMod.res("textures/gui/slot_background.png");
    public static final ResourceLocation SLIDER = UsefulTextures.getGuiLocation("container/loom.png");
    public static final ResourceLocation ARROWS = UsefulTextures.getGuiLocation("server_selection.png");

    private static ResourceLocation getGuiLocation(String path) {
        return ResourceLocation.withDefaultNamespace((String)("textures/gui/" + path));
    }

    public static void renderCheckMark(GuiGraphics graphics, int checkBoxX, int checkBoxY) {
        graphics.blit(CHECK_MARK, checkBoxX, checkBoxY, 0, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    public static void renderCross(GuiGraphics graphics, int x, int y, int size) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale((float)size / 8.0f, (float)size / 7.0f, 0.0f);
        graphics.blit(CROSS, 0, 0, 0, 0.0f, 0.0f, 8, 7, 8, 7);
        graphics.pose().popPose();
    }

    public static void renderSliderWithLine(GuiGraphics graphics, int sliderWidth, boolean showLine, float movePercent, int rightAlignment, int minY, int height) {
        graphics.fill(rightAlignment - sliderWidth, minY, rightAlignment, minY + height, 0x2DFFFFFF);
        UsefulTextures.renderSlider(graphics, rightAlignment - sliderWidth, minY + (int)(movePercent * (float)(height - UsefulTextures.sliderHeightForWidth(sliderWidth))), showLine, (float)sliderWidth / 12.0f);
    }

    public static int sliderHeightForWidth(int width) {
        return 15 * width / 12;
    }

    public static void renderSlider(GuiGraphics graphics, int x, int y, boolean light, float scale) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale(scale, scale, 0.0f);
        graphics.blit(SLIDER, 0, 0, 232 + (light ? 0 : 12), 0, 12, 15);
        graphics.pose().popPose();
    }

    public static void renderUpButton(GuiGraphics graphics, int pLeft, int pTop, boolean hovered, int size) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)pLeft, (float)pTop, 0.0f);
        float scale = (float)size / 16.0f;
        graphics.pose().scale(scale, scale, 0.0f);
        if (hovered) {
            graphics.blit(ARROWS, 0, 0, 96, 32, 32, 32);
        } else {
            graphics.blit(ARROWS, 0, 0, 96, 0, 32, 32);
        }
        graphics.pose().popPose();
    }

    public static void renderDownButton(GuiGraphics graphics, int pLeft, int pTop, boolean hovered, int size) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)pLeft, (float)(pTop - size), 0.0f);
        graphics.pose().scale((float)size / 16.0f, (float)size / 16.0f, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROWS);
        if (hovered) {
            graphics.blit(ARROWS, 0, 0, 64, 32, 32, 32);
        } else {
            graphics.blit(ARROWS, 0, 0, 64, 0, 32, 32);
        }
        graphics.pose().popPose();
    }

    public static void renderCheckBox(GuiGraphics graphics, int x, int y, int backgroundColor, boolean active) {
        graphics.fill(x - 1, y - 1, x + 9, y + 9, backgroundColor);
        if (active) {
            UsefulTextures.renderCheckMark(graphics, x, y);
        }
    }

    public static void renderCheckBoxWithText(GuiGraphics graphics, int x, int y, int backgroundColor, boolean active, Font font, int textColor, Component text) {
        UsefulTextures.renderCheckBox(graphics, x, y, backgroundColor, active);
        graphics.drawString(font, text, x + 11, y, textColor);
    }

    public static void renderCheckBoxWithText(GuiGraphics graphics, int x, int y, int backgroundColor, boolean active, Font font, int textColor, Component text, boolean dropShadow) {
        UsefulTextures.renderCheckBox(graphics, x, y, backgroundColor, active);
        graphics.drawString(font, text, x + 11, y, textColor, dropShadow);
    }

    public static void renderSlotBackground(GuiGraphics graphics, int slotX, int slotY) {
        graphics.blit(SLOT, slotX - 1, slotY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
    }
}

