/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.widget.ScrollableWidget;
import net.kapitencraft.kap_lib.client.widget.background.WidgetBackground;
import net.kapitencraft.kap_lib.client.widget.text.IDE;
import net.kapitencraft.kap_lib.client.widget.text.IFormatter;
import net.kapitencraft.kap_lib.client.widget.text.ISuggestionProvider;
import net.kapitencraft.kap_lib.client.widget.text.ITextCallback;
import net.kapitencraft.kap_lib.client.widget.text.Suggestion;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.util.Vec2i;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MultiLineTextBox
extends ScrollableWidget {
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int BACKGROUND_COLOR = -16777216;
    private final Font font;
    private final List<String> lineValues = new ArrayList<String>();
    private final List<Integer> lineEndIndexes = new ArrayList<Integer>();
    private String value = "";
    private int frame;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private Vec2i cursorPos2d = new Vec2i(0);
    private Vec2i highlightPos2d = new Vec2i(0);
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUnEditable = 0x707070;
    private WidgetBackground background = WidgetBackground.fill(-16777216);
    @Nullable
    private ISuggestionProvider suggestionBuilder;
    private List<Suggestion> suggestions;
    private int suggestionOffset;
    private String suggestionKey;
    private int suggestionSelectIndex;
    private int suggestionsWidth;
    private LineRenderType lineRenderType = LineRenderType.DISABLED;
    @Nullable
    private Consumer<String> responder;
    private Consumer<List<String>> textConsumer = list -> {};
    private Predicate<String> filter = Objects::nonNull;
    private Consumer<Integer> lineCreationConsumer = i -> {};
    private Consumer<Integer> lineRemovedConsumer = i -> {};
    private BiConsumer<Integer, String> lineModificationConsumer = (integer, string) -> {};
    private IFormatter formatter = (string, i) -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY);
    @Nullable
    private Component hint;

    public MultiLineTextBox(Font pFont, int pX, int pY, int pWidth, int pHeight, Component pMessage) {
        this(pFont, pX, pY, pWidth, pHeight, null, pMessage);
    }

    public MultiLineTextBox(Font pFont, int pX, int pY, int pWidth, int pHeight, @Nullable MultiLineTextBox pEditBox, Component pMessage) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.font = pFont;
        if (pEditBox != null) {
            this.value = pEditBox.value;
            this.cursorPos2d = pEditBox.cursorPos2d;
            this.highlightPos2d = pEditBox.highlightPos2d;
            this.highlightPos = pEditBox.highlightPos;
            this.cursorPos = pEditBox.cursorPos;
            this.scrollX = pEditBox.scrollX;
            this.scrollY = pEditBox.scrollY;
        }
        this.applyText2d();
        this.scrollX = 2.0f;
        this.scrollY = 2.0f;
    }

    public void setFormatter(IFormatter pTextFormatter) {
        this.formatter = pTextFormatter;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextColorUnEditable(int textColorUnEditable) {
        this.textColorUnEditable = textColorUnEditable;
    }

    public void setTextCallback(ITextCallback callback) {
        this.onLineCreated(callback::lineCreated);
        this.onLineModified(callback::lineModified);
        this.onLineRemoved(callback::lineRemoved);
    }

    public void setIDE(IDE ide) {
        this.setTextCallback(ide);
        this.setFormatter(ide);
        this.setSuggestionBuilder(ide);
    }

    public void onLineCreated(Consumer<Integer> lineCreationConsumer) {
        this.lineCreationConsumer = lineCreationConsumer;
    }

    public void onLineModified(BiConsumer<Integer, String> lineModificationConsumer) {
        this.lineModificationConsumer = lineModificationConsumer;
    }

    public void onTextModified(Consumer<List<String>> textConsumer) {
        this.textConsumer = textConsumer;
    }

    public void onLineRemoved(Consumer<Integer> lineRemovedConsumer) {
        this.lineRemovedConsumer = lineRemovedConsumer;
    }

    public void tick() {
        ++this.frame;
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        Component component = this.getMessage();
        return Component.translatable((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void setValue(String pText) {
        if (this.filter.test(pText)) {
            this.value = pText;
            this.applyText2d();
            this.moveCursorToEnd();
            this.moveHighlightToCursor();
            this.onValueChange(pText);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void insertText(String pTextToWrite) {
        String insert;
        int insertLength;
        int selectionStart = Math.min(this.cursorPos, this.highlightPos);
        int selectionEnd = Math.max(this.cursorPos, this.highlightPos);
        int space = Integer.MAX_VALUE - this.value.length() - (selectionStart - selectionEnd);
        if (space < (insertLength = (insert = StringUtil.filterText((String)pTextToWrite, (boolean)true)).length())) {
            insert = insert.substring(0, space);
            insertLength = space;
        }
        this.updateText(insert, selectionStart, selectionEnd, insertLength);
    }

    private void updateText(String insert, int selectionStart, int selectionEnd, int insertLength) {
        String s1 = new StringBuilder(this.value).replace(selectionStart, selectionEnd, insert).toString();
        if (this.filter.test(s1)) {
            this.value = s1;
            this.setHighlightPos(this.cursorPos);
            this.updateText2d(insert, selectionStart, selectionEnd);
            this.onValueChange(this.value);
            this.setCursorPosition1d(selectionStart + Math.max(0, insertLength));
        }
    }

    private void updateText2d(String insert, int selectionStart, int selectionEnd) {
        int removeLineFirstIndex;
        List<String> insert2d = List.of(insert.split("\n", Integer.MAX_VALUE));
        Vec2i startLineIndex = this.get2dPositionFrom1dPosition(selectionStart);
        Vec2i endLineIndex = this.get2dPositionFrom1dPosition(selectionEnd);
        if (insert2d.isEmpty()) {
            KapLibMod.LOGGER.warn("trying to insert nothing into Multiline textbox; skipping!");
            return;
        }
        String lastLineRemaining = this.getFromEndSection(endLineIndex);
        if (insert2d.size() > 1) {
            this.updateLine(startLineIndex.y, this.getFromStartSection(startLineIndex) + insert2d.getFirst());
        }
        int lineIndex = startLineIndex.y;
        for (int i = 1; i < insert2d.size(); ++i) {
            if (lineIndex < endLineIndex.y) {
                this.updateLine(lineIndex, insert2d.get(i));
            } else {
                this.addLine(lineIndex + 1, insert2d.get(i));
            }
            ++lineIndex;
        }
        for (int i = removeLineFirstIndex = Math.max(lineIndex, startLineIndex.y + 1); i <= endLineIndex.y; ++i) {
            this.removeLine(removeLineFirstIndex);
        }
        this.updateLine(lineIndex, (insert2d.size() == 1 ? this.getFromStartSection(startLineIndex) : "") + insert2d.getLast() + lastLineRemaining);
    }

    private void notifyCreationAndChange(int index, boolean updateText) {
        this.lineEndIndexes.add(index, this.lineValues.get(index).length());
        this.lineCreationConsumer.accept(index);
        this.notifyChange(index, updateText);
    }

    private String getFromStartSection(Vec2i def) {
        return this.lineValues.get(def.y).substring(0, def.x);
    }

    private String getFromEndSection(Vec2i def) {
        return this.lineValues.get(def.y).substring(def.x);
    }

    private void updateLine(int index, String insert) {
        if (insert != null && !insert.equals(this.lineValues.get(index))) {
            this.lineValues.set(index, insert);
            this.notifyChange(index, true);
        }
    }

    private void addLine(int index, String insert) {
        this.lineValues.add(index, insert);
        this.notifyCreationAndChange(index, true);
    }

    private void removeLine(int index) {
        this.lineValues.remove(index);
        this.lineRemovedConsumer.accept(index);
    }

    private void notifyChange(int index, boolean updateText) {
        String value = this.lineValues.get(index);
        this.lineEndIndexes.set(index, value.length());
        this.lineModificationConsumer.accept(index, value);
        if (updateText) {
            this.textConsumer.accept(this.lineValues);
        }
    }

    private Vec2i get2dPositionFrom1dPosition(int pos) {
        int loc = 0;
        for (int i = 0; i < this.lineEndIndexes.size(); ++i) {
            if (pos <= loc + this.lineEndIndexes.get(i)) {
                if (pos - loc < 0 || pos - loc > this.lineEndIndexes.get(i)) {
                    KapLibMod.LOGGER.error("illegal x location detected: {}", (Object)(pos - loc));
                }
                return new Vec2i(pos - loc, i);
            }
            loc += this.lineEndIndexes.get(i).intValue();
            ++loc;
        }
        return Vec2i.ZERO;
    }

    private void applyText2d() {
        int i;
        ArrayList<String> oldValues = new ArrayList<String>(this.lineValues);
        this.lineValues.clear();
        StringBuilder builder = new StringBuilder();
        int lineIndex = 0;
        boolean textChanged = false;
        for (i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                this.lineValues.add(builder.toString());
                if (!Objects.equals(oldValues.get(lineIndex), this.lineValues.get(lineIndex))) {
                    this.notifyChange(lineIndex, false);
                    textChanged = true;
                }
                ++lineIndex;
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
        }
        this.lineValues.add(builder.toString());
        if (this.lineValues.size() > oldValues.size()) {
            for (i = oldValues.size(); i < this.lineValues.size(); ++i) {
                this.notifyCreationAndChange(i, false);
                textChanged = true;
            }
        }
        if (textChanged) {
            this.textConsumer.accept(this.lineValues);
        }
    }

    private void onValueChange(String pNewText) {
        if (this.responder != null) {
            this.responder.accept(pNewText);
        }
    }

    private void deleteText(int pCount) {
        if (Screen.hasControlDown()) {
            this.deleteWords(pCount);
        } else {
            this.deleteChars(pCount);
        }
    }

    public void deleteWords(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(pNum) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                int k;
                int i = this.getCursorPos(pNum);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos))) {
                    this.updateText("", j, k, pNum);
                }
            }
        }
    }

    public int getWordPosition(int pNumWords) {
        return this.getWordPosition(pNumWords, this.getCursorPosition());
    }

    private int getWordPosition(int pN, int pPos) {
        return this.getWordPosition(pN, pPos, true);
    }

    private int getWordPosition(int pN, int pPos, boolean pSkipWs) {
        int i = pPos;
        boolean flag = pN < 0;
        int j = Math.abs(pN);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (pSkipWs && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (pSkipWs && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    private int getWordPosition2d(int pN) {
        return this.getWordPosition2d(pN, this.cursorPos2d);
    }

    private int getWordPosition2d(int pN, Vec2i pPos) {
        return this.getWordPosition2d(pN, pPos, true);
    }

    private int getWordPosition2d(int pN, Vec2i pPos, boolean pSkipWs) {
        int i = pPos.x;
        boolean flag = pN < 0;
        int j = Math.abs(pN);
        String value = this.lineValues.get(pPos.y);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = value.length();
                if ((i = value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (pSkipWs && i < l && value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (pSkipWs && i > 0 && value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pDelta) {
        this.setCursorPosition2d(this.getCursorPos(pDelta));
    }

    public void moveCursorVertical(int pDelta) {
        int curXWidth = this.font.width(this.lineValues.get(this.cursorPos2d.y).substring(0, this.cursorPos2d.x));
        int newY = Mth.clamp((int)(this.cursorPos2d.y + pDelta), (int)0, (int)(this.lineValues.size() - 1));
        String subs = this.font.plainSubstrByWidth(this.lineValues.get(newY), curXWidth);
        this.setCursorPosition2d(subs.length(), newY);
    }

    private int getCursorPos(int pDelta) {
        return Util.offsetByCodepoints((String)this.value, (int)this.cursorPos, (int)pDelta);
    }

    public void setCursorPosition2d(int pPos) {
        this.setCursorPosition1d(pPos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    private void setCursorPosition2d(int xPos, int yPos) {
        this.cursorPos2d = new Vec2i(xPos, yPos);
        int pos = 0;
        int line = 0;
        for (String s : this.lineValues) {
            if (line == yPos) break;
            pos += s.length();
            ++pos;
            ++line;
        }
        this.cursorPos = pos + xPos;
        this.reapplyPositionsAndScroll();
    }

    public void setCursorPosition1d(int pPos) {
        this.cursorPos = Mth.clamp((int)pPos, (int)0, (int)this.value.length());
        this.reapplyPositionsAndScroll();
    }

    private void reapplyCursor2d() {
        int loc = 0;
        for (int i = 0; i < this.lineEndIndexes.size(); ++i) {
            if (this.cursorPos <= loc + this.lineEndIndexes.get(i)) {
                this.cursorPos2d = new Vec2i(this.cursorPos - loc, i);
                if (this.cursorPos - loc >= 0 && this.cursorPos - loc <= this.lineEndIndexes.get(i)) break;
                KapLibMod.LOGGER.error("cursor index set to illegal x state: {}", (Object)(this.cursorPos - loc));
                break;
            }
            loc += this.lineEndIndexes.get(i).intValue();
            ++loc;
        }
        this.reapplySuggestions();
    }

    private void applySuggestions() {
        List<String> suggestions = this.suggestionBuilder == null ? List.of(this.suggestionKey, "aaaaaa", "abcdefgh") : this.suggestionBuilder.suggestions(this.suggestionKey);
        ArrayList<Suggestion> suggestionList = new ArrayList<Suggestion>();
        suggestions.forEach(string1 -> {
            if (string1.isEmpty()) {
                return;
            }
            int markIndex = TextHelper.getMatchingAmount(this.suggestionKey, string1);
            if (markIndex == 0) {
                return;
            }
            suggestionList.add(new Suggestion(markIndex, (String)string1));
        });
        this.suggestions = suggestionList;
        if (this.suggestionSelectIndex >= this.suggestions.size()) {
            this.suggestionSelectIndex = 0;
        }
        this.suggestionsWidth = this.suggestions.stream().mapToInt(sug -> sug.getWidth(this.font)).max().orElse(0);
    }

    private void enterSuggestion() {
        Suggestion suggestion = this.suggestions.get(this.suggestionSelectIndex);
        suggestion.insertString(this::insertText);
    }

    private void reapplySuggestions() {
        int suggestionOffsetIndex = Math.max(0, this.getWordPosition2d(-1));
        this.suggestionKey = this.lineValues.get(this.cursorPos2d.y).substring(suggestionOffsetIndex, this.cursorPos2d.x);
        this.suggestionOffset = this.font.width(this.getFromStartSection(new Vec2i(suggestionOffsetIndex, this.cursorPos2d.y)));
        this.applySuggestions();
    }

    private boolean hasSuggestions() {
        return this.suggestions != null && !this.suggestions.isEmpty();
    }

    private void reapplyHighlight2d() {
        int loc = 0;
        for (int i = 0; i < this.lineValues.size(); ++i) {
            if (this.highlightPos <= loc + this.lineEndIndexes.get(i)) {
                this.highlightPos2d = new Vec2i(this.highlightPos - loc, i);
                if (this.highlightPos - loc < 0 || this.highlightPos - loc > this.lineEndIndexes.get(i)) {
                    KapLibMod.LOGGER.error("highlight index set to illegal x state: {}", (Object)(this.highlightPos - loc));
                }
                return;
            }
            loc += this.lineEndIndexes.get(i).intValue();
            ++loc;
        }
    }

    private void reapplyPositionsAndScroll() {
        this.reapplyCursor2d();
        this.updateScroll(false);
        if (!Screen.hasShiftDown()) {
            this.moveHighlightToCursor();
        }
    }

    public void moveCursorToStart() {
        this.setCursorPosition2d(0);
    }

    public void moveCursorToEnd() {
        this.setCursorPosition2d(this.value.length());
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)pKeyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.isCopy((int)pKeyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            return true;
        }
        if (Screen.isPaste((int)pKeyCode)) {
            if (this.isEditable) {
                this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            }
            return true;
        }
        if (Screen.isCut((int)pKeyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        return switch (pKeyCode) {
            case 256 -> {
                this.setFocused(false);
                yield true;
            }
            case 257 -> {
                if (this.hasSuggestions()) {
                    this.enterSuggestion();
                } else {
                    this.insertText("\n");
                }
                yield true;
            }
            case 258 -> {
                if (this.hasSuggestions()) {
                    this.enterSuggestion();
                } else {
                    this.insertText("\t");
                }
                yield true;
            }
            case 259 -> {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.hasShiftDown();
                }
                yield true;
            }
            case 261 -> {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.hasShiftDown();
                }
                yield true;
            }
            case 262 -> {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition2d(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                yield true;
            }
            case 263 -> {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition2d(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                yield true;
            }
            case 264 -> {
                if (this.hasSuggestions()) {
                    this.suggestionSelectIndex = this.suggestionSelectIndex == this.suggestions.size() - 1 ? 0 : ++this.suggestionSelectIndex;
                } else {
                    this.moveCursorVertical(1);
                }
                yield true;
            }
            case 265 -> {
                if (this.hasSuggestions()) {
                    this.suggestionSelectIndex = this.suggestionSelectIndex == 0 ? this.suggestions.size() - 1 : --this.suggestionSelectIndex;
                } else {
                    this.moveCursorVertical(-1);
                }
                yield true;
            }
            case 268 -> {
                this.moveCursorToStart();
                yield true;
            }
            case 269 -> {
                this.moveCursorToEnd();
                yield true;
            }
            default -> false;
        };
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (StringUtil.isAllowedChatCharacter((char)pCodePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(pCodePoint));
            }
            return true;
        }
        return false;
    }

    public void onClick(double pMouseX, double pMouseY) {
        if (this.value.isEmpty()) {
            this.setCursorPosition2d(0);
            return;
        }
        int xOffset = Mth.floor((double)pMouseX) - this.getX() - Mth.floor((float)this.scrollX) - this.getLineMarkerWidth();
        int yOffset = Mth.floor((double)pMouseY) - this.getY() - Mth.floor((float)this.scrollY);
        int line = Mth.clamp((int)(yOffset / 10), (int)0, (int)(this.lineValues.size() - 1));
        this.setCursorPosition2d(this.font.plainSubstrByWidth(this.lineValues.get(line), xOffset).length(), line);
    }

    private void moveHighlightToCursor() {
        this.highlightPos = this.cursorPos;
        this.highlightPos2d = this.cursorPos2d;
    }

    public void onClose() {
        ClientHelper.changeCursorType(221185);
    }

    public void playDownSound(@NotNull SoundManager pHandler) {
    }

    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        ClientHelper.changeCursorType(this.isHovered() ? 221186 : 221185);
        this.background.render(false, pGuiGraphics, this.getX(), this.getY(), this.width, this.height, this.scrollX, this.scrollY);
        int textXStart = this.getX() + this.getLineMarkerWidth();
        pGuiGraphics.enableScissor(textXStart, this.getY(), this.getX() + this.width, this.getY() + this.height);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)textXStart, (float)this.getY(), 0.0f);
        int textColor = this.isEditable ? this.textColor : this.textColorUnEditable;
        int x = Mth.floor((float)this.scrollX);
        int yBase = Mth.floor((float)this.scrollY);
        int cursorX = x + this.font.width(this.getFromStartSection(this.cursorPos2d));
        for (int lineIndex = 0; lineIndex < this.lineValues.size(); ++lineIndex) {
            String line = this.lineValues.get(lineIndex);
            boolean cursorInLine = this.cursorPos2d.y == lineIndex;
            boolean showCursor = this.isFocused() && this.frame / 6 % 2 == 0 && cursorInLine;
            int y = yBase + lineIndex * 10;
            if (!line.isEmpty()) {
                pGuiGraphics.drawString(this.font, this.formatter.format(line, lineIndex), x, y, textColor);
            }
            if (showCursor) {
                if (!this.value.isEmpty()) {
                    pGuiGraphics.fill(RenderType.guiOverlay(), cursorX, y - 1, cursorX + 1, y + 1 + 9, -3092272);
                } else {
                    pGuiGraphics.drawString(this.font, CURSOR_APPEND_CHARACTER, cursorX, y, textColor);
                }
            }
            if (this.highlightPos == this.cursorPos) continue;
            this.renderHighlight(lineIndex, line, pGuiGraphics, x, y);
        }
        pGuiGraphics.pose().popPose();
        pGuiGraphics.disableScissor();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        if (this.lineRenderType != LineRenderType.DISABLED) {
            pGuiGraphics.enableScissor(this.getX(), this.getY(), textXStart, this.getY() + this.height);
            for (int i = 0; i < this.lineValues.size(); ++i) {
                if (i % this.lineRenderType.lineOffset != 0) continue;
                pGuiGraphics.drawString(this.font, String.valueOf(i + 1), 1, yBase + i * 10, textColor);
            }
            pGuiGraphics.disableScissor();
        }
        this.renderSuggestions(pGuiGraphics, this.suggestionOffset + this.getLineMarkerWidth() + x, yBase + (this.cursorPos2d.y + 1) * 10);
        pGuiGraphics.pose().popPose();
    }

    private void renderSuggestions(GuiGraphics graphics, int renderStart, int y) {
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        if (this.suggestions != null && !this.suggestions.isEmpty()) {
            graphics.fill(renderStart - 1, y, renderStart + this.suggestionsWidth, y + 2 + 10 * this.suggestions.size(), -11513776);
            for (int i = 0; i < this.suggestions.size(); ++i) {
                if (this.suggestionSelectIndex == i) {
                    graphics.fill(renderStart - 1, y + i * 10, renderStart + this.suggestionsWidth, y + 12 + i * 10, -3878972);
                }
                graphics.drawString(this.font, this.suggestions.get(i).getRenderable(), renderStart, y + 1 + 10 * i, -1);
            }
        }
    }

    private int getLineMarkerWidth() {
        return this.lineRenderType == LineRenderType.DISABLED ? 0 : 40;
    }

    private void renderHighlight(int lineIndex, String line, GuiGraphics graphics, int x, int y) {
        Vec2i highlightStart = this.getHighlightPos(true);
        Vec2i highlightEnd = this.getHighlightPos(false);
        String highlighted = line;
        int highlightStartIndex = 0;
        int highlightEndIndex = line.length();
        if (highlightEnd.y == lineIndex) {
            highlighted = highlighted.substring(0, highlightEnd.x);
            highlightEndIndex = highlightEnd.x;
        }
        if (highlightStart.y == lineIndex) {
            highlighted = highlighted.substring(highlightStart.x);
            highlightStartIndex = highlightStart.x;
        }
        if (highlightStart.y > lineIndex || highlightEnd.y < lineIndex) {
            highlighted = "";
        }
        if (!highlighted.isEmpty()) {
            int highlightOffset = this.font.width(line.substring(0, highlightStartIndex));
            int highlightWidth = this.font.width(line.substring(highlightStartIndex, highlightEndIndex));
            this.renderHighlight(graphics, x + highlightOffset, y - 1, x + highlightOffset + highlightWidth, y + 10);
        }
    }

    private Vec2i getHighlightPos(boolean start) {
        return this.highlightPos < this.cursorPos == start ? this.highlightPos2d : this.cursorPos2d;
    }

    private void renderHighlight(GuiGraphics pGuiGraphics, int pMinX, int pMinY, int pMaxX, int pMaxY) {
        if (pMinX < pMaxX) {
            int i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            int j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        if (pMaxX > this.getX() + this.width) {
            pMaxX = this.getX() + this.width;
        }
        if (pMinX > this.getX() + this.width) {
            pMinX = this.getX() + this.width;
        }
        pGuiGraphics.fill(RenderType.guiTextHighlight(), pMinX, pMinY, pMaxX, pMaxY, -16776961);
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    @Nullable
    public ComponentPath nextFocusPath(@NotNull FocusNavigationEvent pEvent) {
        return this.visible && this.isEditable ? super.nextFocusPath(pEvent) : null;
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return this.visible && MathHelper.is2dBetween(pMouseX, pMouseY, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
    }

    public void setFocused(boolean pFocused) {
        if (this.canLoseFocus || pFocused) {
            super.setFocused(pFocused);
            if (pFocused) {
                this.frame = 0;
            }
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean pEnabled) {
        this.isEditable = pEnabled;
    }

    public void setHighlightPos(int pPosition) {
        int i = this.value.length();
        this.highlightPos = Mth.clamp((int)pPosition, (int)0, (int)i);
        this.reapplyHighlight2d();
    }

    public void setLineRenderType(LineRenderType type) {
        this.lineRenderType = type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean pIsVisible) {
        this.visible = pIsVisible;
    }

    public void setSuggestionBuilder(@Nullable ISuggestionProvider pSuggestion) {
        this.suggestionBuilder = pSuggestion;
    }

    public void setTextChangeHook(Consumer<List<String>> textConsumer) {
        this.textConsumer = textConsumer;
    }

    public int getScreenX(int pCharNum) {
        return pCharNum > this.value.length() ? this.getX() : this.getX() + this.font.width(this.value.substring(0, pCharNum));
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public void setTextureBackground(ResourceLocation backgroundLocation) {
        this.background = WidgetBackground.texture(backgroundLocation, 16, 16);
    }

    public void setBackground(WidgetBackground background) {
        this.background = background;
    }

    @Override
    protected void updateScroll(boolean ignoreCursor) {
        if (this.canScroll(false)) {
            if (!ignoreCursor) {
                if ((float)((this.cursorPos2d.y + 1) * 10) + this.scrollY >= (float)this.height) {
                    this.scrollY = this.height - (this.cursorPos2d.y + 1) * 10;
                } else if ((float)(this.cursorPos2d.y * 10) + this.scrollY < (float)(ClientModConfig.getCursorMoveOffset() * 10)) {
                    this.scrollY += 10.0f;
                }
            }
            this.scrollY = Mth.clamp((float)this.scrollY, (float)(-this.valueSize(false) + this.height + 2), (float)2.0f);
        } else {
            this.scrollY = 2.0f;
        }
        if (this.canScroll(true)) {
            int offsetWidth;
            if (!ignoreCursor && (float)(offsetWidth = this.font.width(this.lineValues.get(this.cursorPos2d.y).substring(0, this.cursorPos2d.x))) + this.scrollX >= (float)this.width) {
                this.scrollX = -offsetWidth + this.width - 2;
            }
            this.scrollX = Mth.clamp((float)this.scrollX, (float)(-this.valueSize(true) + this.width + 2), (float)2.0f);
        } else {
            this.scrollX = 2.0f;
        }
    }

    @Override
    protected int valueSize(boolean x) {
        return x ? MathHelper.getLargest(this.lineValues.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).toList()) : this.lineValues.size() * 10;
    }

    public static enum LineRenderType {
        DISABLED(0),
        EVERY(1),
        EVERY5(5),
        EVERY10(10);

        private final int lineOffset;

        private LineRenderType(int lineOffset) {
            this.lineOffset = lineOffset;
        }
    }
}

