/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import java.util.List;
import net.kapitencraft.kap_lib.data_gen.ModDamageTypes;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ManaHandler {
    public static final String OVERFLOW_MANA_ID = "overflowMana";

    @SubscribeEvent
    public static void manaChange(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance maxManaInstance = player.getAttribute(ExtraAttributes.MAX_MANA);
        if (!ManaHandler.isMagical((LivingEntity)player)) {
            throw new IllegalStateException("detected Player unable to use mana, expecting broken mod-state!");
        }
        double maxMana = maxManaInstance.getValue();
        double intel = player.getAttributeValue(ExtraAttributes.INTELLIGENCE);
        double curManaRegen = player.getAttributeValue(ExtraAttributes.MANA_REGEN);
        double manaRegen = maxMana / 500.0 * (1.0 + curManaRegen / 100.0);
        CompoundTag tag = player.getPersistentData();
        tag.putDouble("manaRegen", manaRegen);
        ManaHandler.growMana((LivingEntity)player, manaRegen);
        maxMana = 100.0 + intel;
        maxManaInstance.setBaseValue(maxMana);
    }

    public static boolean consumeMana(LivingEntity living, double manaToConsume) {
        if (!ManaHandler.hasMana(living, manaToConsume)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        double overflow = ManaHandler.getOverflow(living);
        if (overflow > manaToConsume) {
            overflow -= manaToConsume;
            manaToConsume = 0.0;
        } else {
            manaToConsume -= overflow;
            overflow = 0.0;
        }
        if (manaToConsume > 0.0) {
            mana -= manaToConsume;
        }
        ManaHandler.setOverflow(living, overflow);
        ManaHandler.setMana(living, mana);
        return true;
    }

    public static boolean hasMana(LivingEntity living, double manaToConsume) {
        double overflow;
        if (manaToConsume <= 0.0) {
            return true;
        }
        if (!ManaHandler.isMagical(living)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        return mana + (overflow = ManaHandler.getOverflow(living)) >= manaToConsume;
    }

    public static double getOverflow(LivingEntity living) {
        return ManaHandler.isMagical(living) ? living.getPersistentData().getDouble(OVERFLOW_MANA_ID) : 0.0;
    }

    public static double getMana(LivingEntity living) {
        return AttributeHelper.getSaveAttributeValue(ExtraAttributes.MANA, living);
    }

    public static void setMana(LivingEntity living, double mana) {
        AttributeInstance instance = living.getAttribute(ExtraAttributes.MANA);
        if (instance != null) {
            instance.setBaseValue(Math.min(mana, living.getAttributeValue(ExtraAttributes.MAX_MANA)));
        }
    }

    public static boolean growMana(LivingEntity living, double mana) {
        ManaHandler.setMana(living, ManaHandler.getMana(living) + mana);
        return ManaHandler.isMagical(living);
    }

    public static boolean isMagical(LivingEntity living) {
        return living.getAttribute(ExtraAttributes.MANA) != null || living.getAttribute(ExtraAttributes.MAX_MANA) != null;
    }

    public static void setOverflow(LivingEntity living, double overflow) {
        if (overflow >= AttributeHelper.getSaveAttributeValue(ExtraAttributes.MAX_MANA, living)) {
            living.hurt(living.damageSources().source(ModDamageTypes.MANA_OVERFLOW_SELF), Float.MAX_VALUE);
            List<LivingEntity> livings = MathHelper.getLivingAround((Entity)living, 5.0);
            for (LivingEntity living1 : livings) {
                living1.hurt(living.damageSources().source(ModDamageTypes.MANA_OVERFLOW, (Entity)living), (float)(3.4028234663852886E38 * (0.01 * (double)Math.max(5.0f - living1.distanceTo((Entity)living), 0.0f))));
            }
        }
        living.getPersistentData().putDouble(OVERFLOW_MANA_ID, overflow);
    }
}

