/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core;

import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.TriggerInstance;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimator;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ActivationTrigger<T extends TriggerInstance> {
    public void addListener(Listener<T> var1);

    public void removeListener(Listener<T> var1);

    public boolean active(Listener<T> var1);

    public void toNw(FriendlyByteBuf var1, T var2);

    public T fromNw(FriendlyByteBuf var1);

    public static <T extends TriggerInstance> T readFromNw(FriendlyByteBuf buf) {
        ActivationTrigger trigger = (ActivationTrigger)buf.readRegistryIdUnsafe(ExtraRegistries.ACTIVATION_TRIGGERS);
        return trigger.fromNw(buf);
    }

    public static <T extends TriggerInstance> void writeToNw(FriendlyByteBuf buf, T val) {
        ActivationTrigger<? extends TriggerInstance> trigger = val.getTrigger();
        buf.writeRegistryIdUnsafe(ExtraRegistries.ACTIVATION_TRIGGERS, trigger);
        trigger.toNw(buf, val);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Listener<T extends TriggerInstance> {
        private final T trigger;
        private final ParticleAnimator animator;

        public Listener(T trigger, ParticleAnimator animator) {
            this.trigger = trigger;
            this.animator = animator;
        }

        public void run() {
            LibClient.animations.triggerComplete(this.animator, (TriggerInstance)this.trigger);
        }

        public T getTrigger() {
            return this.trigger;
        }
    }
}

