/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class TrackingSpawner
extends VisibleSpawner {
    private final PositionTarget target;

    public TrackingSpawner(ParticleOptions particle, PositionTarget target) {
        super(particle);
        this.target = target;
    }

    public String toString() {
        return "TrackingSpawner[" + this.target + "]";
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        sink.accept(this.particle, this.target.get());
    }

    @NotNull
    public Type getType() {
        return (Type)SpawnerTypes.TRACKING.get();
    }

    public static class Type
    implements Spawner.Type<TrackingSpawner> {
        @Override
        public void toNW(FriendlyByteBuf buf, TrackingSpawner value) {
            NetworkHelper.writeParticleOptions(buf, value.particle);
            value.target.toNw(buf);
        }

        @Override
        public TrackingSpawner fromNw(FriendlyByteBuf buf, ClientLevel level) {
            return new TrackingSpawner((ParticleOptions)NetworkHelper.readParticleOptions(buf), PositionTarget.fromNw(buf));
        }
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private PositionTarget target;

        public Builder target(PositionTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new TrackingSpawner(this.particle, this.target);
        }
    }
}

