/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.terminators;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimator;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTriggerInstance;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.compress.utils.Lists;

public class TimedTerminator
implements TerminationTrigger<Instance> {
    private final Set<TerminationTrigger.Listener<Instance>> listeners = Sets.newHashSet();

    public static TerminationTriggerInstance seconds(int i) {
        return new Instance(i * 20);
    }

    public static TerminationTriggerInstance ticks(int ticks) {
        return new Instance(ticks);
    }

    @Override
    public void addListener(ParticleAnimator animator, TerminationTrigger.Listener<Instance> terminator) {
        this.listeners.add(terminator);
    }

    @Override
    public void removeListener(ParticleAnimator animator, TerminationTrigger.Listener<Instance> terminator) {
        this.listeners.remove(terminator);
    }

    @Override
    public void clearListeners(ParticleAnimator animator) {
        this.listeners.removeIf(tListener -> tListener.isFor(animator));
    }

    @Override
    public void toNw(FriendlyByteBuf buf, Instance terminator) {
        buf.writeInt(terminator.duration);
    }

    public void trigger() {
        List list = null;
        for (TerminationTrigger.Listener<Instance> listener : this.listeners) {
            if (listener.trigger().duration > listener.animator().runningTicks) continue;
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(listener);
        }
        if (list != null) {
            for (TerminationTrigger.Listener<Instance> listener : list) {
                listener.run(LibClient.animations);
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    public Instance fromNw(FriendlyByteBuf buf) {
        return new Instance(buf.readInt());
    }

    public static class Instance
    implements TerminationTriggerInstance {
        private final int duration;

        public Instance(int duration) {
            this.duration = duration;
        }

        @Override
        public TerminationTrigger<? extends TerminationTriggerInstance> getTrigger() {
            return (TerminationTrigger)TerminatorTriggers.TIMED.get();
        }
    }
}

