/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.client.widget.Widget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public abstract class MultiElementSelectorWidget<K>
extends PositionedWidget {
    private static final int SLIDER_WIDTH = 6;
    protected K active = null;
    protected final List<ElementButton> buttons = new ArrayList<ElementButton>();
    protected int allElementsSize;
    private int scrollOffset;
    private boolean scrolling;

    public MultiElementSelectorWidget(int x, int y, int width, int elementSize, int height, List<K> elements) {
        super(x, y, width * elementSize, height);
        int widthAddition = 0;
        int heightAddition = 0;
        for (K element : elements) {
            int xStart = x + elementSize * widthAddition;
            int yStart = y + elementSize * heightAddition;
            this.createElement(this.buttons::add, xStart, yStart, elementSize, element);
            if (widthAddition++ < width - 1) continue;
            ++heightAddition;
            widthAddition = 0;
        }
        this.allElementsSize = elements.size() * elementSize;
    }

    protected abstract void createElement(Consumer<ElementButton> var1, int var2, int var3, int var4, K var5);

    private boolean canScroll() {
        return this.allElementsSize > this.height;
    }

    private boolean shouldShowSlider(double pMouseX, double pMouseY) {
        return this.canScroll() && MathHelper.is2dBetween(pMouseX, pMouseY, this.getMaxX() - 6, this.y, this.getMaxX(), this.getMaxY());
    }

    protected void renderInternal(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.m_280509_(-1, -1, this.width + 1, this.height + 1, -12566464);
        this.buttons.stream().filter(ElementButton::isShown).forEach(coloredButton -> coloredButton.m_88315_(graphics, pMouseX, pMouseY, pPartialTick));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.m_280588_(this.x, this.y, this.x + this.width, this.y + this.height);
        this.renderInternal(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.m_280618_();
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            this.renderSlider(graphics, pMouseX, pMouseY);
        }
    }

    private void renderSlider(GuiGraphics graphics, int pMouseX, int pMouseY) {
        float movePercent = (float)this.scrollOffset / (float)this.allElementsSize;
        boolean flag = MathHelper.is2dBetween(pMouseX, pMouseY, this.getMaxX() - 6, this.y, this.getMaxX(), this.getMaxY());
        UsefulTextures.renderSliderWithLine(graphics, 6, flag, movePercent, this.getMaxX(), 0, this.height);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.hovered(pMouseX, pMouseY)) {
            this.scrollOffset = (int)((double)this.scrollOffset + pDelta);
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            this.scrolling = true;
            return true;
        }
        return new ArrayList<ElementButton>(this.buttons).stream().filter(ElementButton::isShown).anyMatch(coloredButton -> coloredButton.m_6375_(pMouseX, pMouseY, pButton));
    }

    protected class ElementButton
    extends Widget {
        protected final K own;
        private final int color;
        protected int y;
        protected final int x;
        protected final int size;

        protected ElementButton(int x, int y, int size, K own, int color) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.own = own;
            this.color = color;
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            boolean flag = MultiElementSelectorWidget.this.active == this.own;
            int xOffset = this.getXOffset();
            int yOffset = this.getYOffset();
            if (flag) {
                graphics.m_280509_(xOffset, yOffset, xOffset + this.size, yOffset + this.size, -2829100);
            }
            graphics.m_280509_(flag ? xOffset + 1 : xOffset, flag ? yOffset + 1 : yOffset, xOffset + this.size - (flag ? 1 : 0), yOffset + this.size - (flag ? 1 : 0), this.color);
        }

        protected int getXOffset() {
            return this.x - MultiElementSelectorWidget.this.x;
        }

        protected int getYOffset() {
            return this.y - MultiElementSelectorWidget.this.y;
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            if (this.hovered(pMouseX, pMouseY)) {
                MultiElementSelectorWidget.this.active = this.own;
                return true;
            }
            return false;
        }

        protected final boolean hovered(double pMouseX, double pMouseY) {
            return pMouseY < (double)MultiElementSelectorWidget.this.getMaxY() && pMouseY > (double)MultiElementSelectorWidget.this.y && MathHelper.is2dBetween(pMouseX, pMouseY, this.x, this.y, this.x + this.size, this.y + this.size);
        }

        public void move(int yRange) {
            this.y += yRange;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{own=" + this.own + ", x=" + this.x + ", y=" + this.y + "}";
        }

        public boolean isShown() {
            MultiElementSelectorWidget selectorWidget = MultiElementSelectorWidget.this;
            return this.y < selectorWidget.getMaxY() && this.y >= selectorWidget.y;
        }
    }
}

