/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.kapitencraft.kap_lib.client.ExtraComponents;
import net.kapitencraft.kap_lib.client.particle.animation.AnimationUtils;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.elements.KeepAliveElement;
import net.kapitencraft.kap_lib.client.particle.animation.elements.MoveAwayElement;
import net.kapitencraft.kap_lib.client.particle.animation.elements.RotateElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.RemoveParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.SetLifeTimeFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.LineSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.RingSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.RotationTarget;
import net.kapitencraft.kap_lib.helpers.CommandHelper;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.spawn_table.SpawnTableManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ServerTestCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"server_test").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"animation").then(Commands.m_82127_((String)"rotation").executes(ServerTestCommand::testRotation))).then(Commands.m_82127_((String)"arrow").executes(ServerTestCommand::testArrow))).then(Commands.m_82127_((String)"aura").executes(ServerTestCommand::testAura))).then(Commands.m_82127_((String)"star").executes(ServerTestCommand::testStar))).then(Commands.m_82127_((String)"line").executes(ServerTestCommand::testLine)))).then(Commands.m_82127_((String)"spawn_table").executes(ServerTestCommand::testSpawnTable))).then(Commands.m_82127_((String)"player_head").executes(ServerTestCommand::testPlayerHeadGlyph))).then(Commands.m_82127_((String)"tooltip").executes(ServerTestCommand::testLargeTooltip)));
    }

    private static int testLargeTooltip(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42415_);
            CompoundTag tag = stack.m_41698_("display");
            ListTag lore = new ListTag();
            List<String> loreData = List.of("Minecraft is a 2011 sandbox game developed and published by the Swedish video game developer Mojang Studios.", "Originally created by Markus \"Notch\" Persson using the Java programming language, the first public alpha build was released on 17 May 2009.", "The game was continuously developed from then on, receiving a full release on 18 November 2011.", "Afterwards, Persson left Mojang and gave Jens \"Jeb\" Bergensten control over development.", "In the years since its release, it has been ported to several platforms, including smartphones, tablets, and various video game consoles.", "In 2014, Mojang and the Minecraft intellectual property were purchased by Microsoft for US$2.5 billion.", "", "In Minecraft, players explore a procedurally generated, three-dimensional world with virtually infinite terrain made up of voxels.", "Players can discover and extract raw materials, craft tools and items, and build structures, earthworks, and machines.", "Depending on their chosen game mode, players can fight hostile mobs, as well as cooperate with or compete against other players in multiplayer.", "The game has two main modes: Survival mode, where players must acquire resources to survive, and Creative mode, where players have unlimited resources and the ability to fly.", "The game can be further interacted with through Hardcore mode, a permadeath variant of Survival, as well as player-made downloadable maps or self-imposed challenges.", "The game's large community offers a wide variety of user-generated content, such as modifications, servers, player skins, texture packs, and custom maps, which add new game mechanics and possibilities.", "Speedrunning is another popular community activity.", "", "Minecraft is the best-selling video game of all time, with over 350 million copies sold and nearly 170 million monthly active players as of 2025.", "In addition, it has received critical acclaim, winning several awards and being cited as one of the greatest video games of all time;", "social media, parodies, adaptations, merchandise, and the annual Minecon conventions have played prominent roles in popularizing the game.", "Minecraft has been used in educational environments to teach chemistry, computer-aided design, and computer science.", "The wider Minecraft franchise includes several spin-off games including Minecraft: Story Mode, Minecraft Earth, Minecraft Dungeons, and Minecraft Legends.", "A live-action film adaptation, titled A Minecraft Movie, was released in theatres on 4 April 2025. ");
            loreData.stream().map(Component::m_237113_).map(Component.Serializer::m_130703_).map(StringTag::m_129297_).forEach(arg_0 -> lore.add(arg_0));
            tag.m_128365_("Lore", (Tag)lore);
            player.m_36356_(stack);
            return 1;
        });
    }

    private static int testPlayerHeadGlyph(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            MinecraftServer server = Objects.requireNonNull(player.m_20194_());
            List players = server.m_6846_().m_11314_();
            MutableComponent text = Component.m_237119_();
            for (ServerPlayer p : players) {
                text.m_7220_((Component)ExtraComponents.playerHead(p.m_20148_()));
            }
            player.m_213846_((Component)text);
            return 1;
        });
    }

    private static int testSpawnTable(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            LootParams params = new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81460_, (Object)commandSourceStack.m_81371_()).m_287286_(LootContextParams.f_81455_, player).m_287235_(LootContextParamSets.f_81412_);
            SpawnContext spawnContext = new SpawnContext.Builder(params).create(null);
            SpawnTable table = SpawnTableManager.instance.getSpawnTable(new ResourceLocation("test:test"));
            table.getRandomEntities(spawnContext, entity -> entity.m_146884_(commandSourceStack.m_81371_()));
            return 1;
        });
    }

    private static int testStar(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            PositionTarget center = PositionTarget.fixed(player.m_20182_());
            AnimationUtils.star(5, (ParticleOptions)ParticleTypes.f_123745_, (ParticleOptions)ParticleTypes.f_123744_, 0.25f, 5.0f, center).terminatedWhen(TimedTerminator.ticks(600)).finalizes(RemoveParticleFinalizer.builder()).then(RotateElement.builder().angle(1.0f).axis(Direction.Axis.Y).pivot(center).duration(600)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testLine(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 pos = player.m_20182_();
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.once()).spawn((Spawner.Builder)LineSpawner.builder().start(PositionTarget.fixed(pos)).end(PositionTarget.fixed(pos.m_82520_(0.0, 10.0, 0.0))).spacing(0.25f).setParticle((ParticleOptions)ParticleTypes.f_123744_)).terminatedWhen(TimedTerminator.seconds(10)).finalizes(RemoveParticleFinalizer.builder()).then(KeepAliveElement.forDuration(200)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testAura(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn(((RingSpawner.Builder)RingSpawner.entityWithBBSize((Entity)player, 1.7f, 1.0f).setParticle((ParticleOptions)ParticleTypes.f_123744_)).rotPerTick(5.0f).heightPerTick(0.02f)).terminatedWhen(TimedTerminator.ticks(600)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testArrow(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Arrow arrow = new Arrow(player.m_9236_(), (LivingEntity)player);
            arrow.m_146884_(player.m_20182_());
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.5f, 0.0f);
            player.m_9236_().m_7967_((Entity)arrow);
            ParticleAnimation.requireEntity((Entity)arrow).spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn((Spawner.Builder)RingSpawner.noHeight().setTarget(PositionTarget.entity((Entity)arrow)).rotation(RotationTarget.forEntity((Entity)arrow)).spawnCount(2).rotPerTick(5.0f).axis(Direction.Axis.Z).radius(0.3f).setParticle((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)0xFFFFFF).m_252839_(), 0.34f))).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testRotation(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 playerPos = player.m_20182_();
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(RemoveParticleFinalizer.builder()).spawn((Spawner.Builder)RingSpawner.noHeight().axis(Direction.Axis.Y).radius(0.1f).rotPerTick(1.0f).setTarget(PositionTarget.fixed(playerPos)).setParticle((ParticleOptions)ParticleTypes.f_123744_)).terminatedWhen(TimedTerminator.ticks(600)).then(MoveAwayElement.builder().speed(0.01f).time(20).target(PositionTarget.fixed(playerPos))).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testAnimation(CommandContext<CommandSourceStack> context) {
        int index = IntegerArgumentType.getInteger(context, (String)"testIndex");
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 playerPos = player.m_20182_();
            if (index != 0) {
                if (index == 1) {
                    ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn(((RingSpawner.Builder)RingSpawner.entityWithBBSize((Entity)player, 1.7f, 1.0f).setParticle((ParticleOptions)ParticleTypes.f_123744_)).rotPerTick(5.0f).heightPerTick(0.02f)).terminatedWhen(TimedTerminator.ticks(600)).sendToPlayer((ServerPlayer)player);
                } else if (index == 2) {
                    // empty if block
                }
            }
            return 1;
        });
    }
}

