/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.abstracts;

import net.kapitencraft.kap_lib.enchantments.abstracts.ExtendedCalculationEnchantment;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public interface EffectApplicationEnchantment
extends ExtendedCalculationEnchantment {
    @Override
    @NotNull
    default public ExtendedCalculationEnchantment.ProcessPriority priority() {
        return ExtendedCalculationEnchantment.ProcessPriority.LOWEST;
    }

    public MobEffect getEffect();

    public int getChance(int var1);

    public int getScale();

    default public int getAmplifier(int level) {
        return 1;
    }

    @Override
    default public float execute(int level, ItemStack enchanted, LivingEntity attacker, LivingEntity attacked, float damage, DamageSource source, float attackStrengthScale) {
        if (RequirementManager.instance.meetsRequirements(RegistryReqType.ENCHANTMENT, (Enchantment)this, attacked) && MathHelper.chance((double)this.getChance(level) / 100.0, attacker) && !MiscHelper.increaseEffectDuration(attacked, this.getEffect(), level * this.getScale())) {
            attacked.m_7292_(new MobEffectInstance(this.getEffect(), level * this.getScale(), this.getAmplifier(level)));
        }
        return damage;
    }

    default public String[] getDescriptionMods(int level) {
        return new String[]{this.getChance(level) + "%", "" + level * this.getScale()};
    }
}

