/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.LootContextReader;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public interface LootTableHelper {
    public static <T extends IConditional> Codec<T> simpleCodec(Function<LootItemCondition[], T> function) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ModLootModifier.LOOT_CONDITIONS_CODEC.optionalFieldOf("conditions", (Object)new LootItemCondition[0]).forGetter(IConditional::getConditions)).apply((Applicative)instance, function));
    }

    public static Player getPlayerSource(LootContext context) {
        Player player;
        Entity entity = LootTableHelper.getEntitySource(context);
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public static LivingEntity getLivingSource(LootContext context) {
        LivingEntity living;
        Entity entity = LootTableHelper.getEntitySource(context);
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public static Entity getEntitySource(LootContext context) {
        return LootContextReader.of(context, Entity.class).withParam((LootContextParam<Entity>)LootContextParams.f_81458_).ifNull((LootContextParam<Entity>)LootContextParams.f_81455_).getValue();
    }
}

