/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.Reference;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    public static final Component EMPTY = Component.m_237113_((String)"");
    private static final List<String> NUMBERS = List.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    private static final List<String> LETTERS_SMALL = List.of("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
    private static final List<String> LETTERS_BIG = LETTERS_SMALL.stream().map(String::toUpperCase).toList();

    public static void sendTitle(Player player, Component title) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(title));
        }
    }

    public static Component chain(List<? extends Component> toChain, boolean or) {
        if (toChain.size() == 1) {
            return toChain.get(0);
        }
        ArrayList<? extends Component> copy = new ArrayList<Component>(toChain);
        MutableComponent component = Component.m_237119_();
        component.m_7220_((Component)copy.get(0));
        copy.remove(0);
        while (copy.size() > 1) {
            component.m_130946_(", ").m_7220_((Component)copy.get(0));
            copy.remove(0);
        }
        if (or) {
            component.m_7220_((Component)Component.m_237115_((String)"component_chain.or"));
        } else {
            component.m_7220_((Component)Component.m_237115_((String)"component_chain.and"));
        }
        component.m_7220_((Component)copy.get(0));
        return component;
    }

    public static Component listToPlainText(List<Component> list) {
        MutableComponent component = Component.m_237119_();
        for (Component c : list) {
            component.m_7220_(c);
            component.m_130946_("\n");
        }
        return component;
    }

    public static float getWidthFromMultiple(Collection<Component> collection, Font font) {
        float f = 0.0f;
        for (Component comp : collection) {
            float f1 = font.m_92852_((FormattedText)comp);
            if (!(f < f1)) continue;
            f = f1;
        }
        return f;
    }

    public static void addEmpty(List<Component> components) {
        components.add(CommonComponents.f_237098_);
    }

    public static List<Component> getAllMatchingFilter(Function<Integer, String> keyMapper, @Nullable UnaryOperator<MutableComponent> styleMods, Object ... args) {
        ArrayList<Component> list = new ArrayList<Component>();
        int i = 0;
        while (I18n.m_118936_((String)keyMapper.apply(i))) {
            MutableComponent component = Component.m_237110_((String)keyMapper.apply(i), (Object[])args);
            if (styleMods != null) {
                list.add((Component)styleMods.apply(component));
            } else {
                list.add((Component)component);
            }
            ++i;
        }
        return list;
    }

    public static List<Component> getDescriptionList(String name, @Nullable UnaryOperator<MutableComponent> styleMods, Object ... args) {
        return TextHelper.getAllMatchingFilter(integer -> {
            String descId = name + ".desc";
            if (!I18n.m_118936_((String)descId)) {
                descId = descId + "ription";
            }
            if (integer != 0) {
                descId = descId + "." + integer;
            }
            return descId;
        }, styleMods, args);
    }

    public static List<Component> getDescriptionOrEmpty(String name, @Nullable UnaryOperator<MutableComponent> styleMods, Object ... args) {
        List<Component> components = TextHelper.getDescriptionList(name, styleMods, args);
        return components.isEmpty() ? List.of(Component.m_237115_((String)"desc.missing")) : components;
    }

    public static String wrapInObfuscation(String source) {
        return TextHelper.wrapInFormatting(source, ChatFormatting.OBFUSCATED);
    }

    public static String wrapInFormatting(Object source, ChatFormatting formatting) {
        char id = formatting.m_178510_();
        boolean obfuscate = id == 'k';
        StringBuilder builder = new StringBuilder();
        String format = "\u00a7" + id;
        builder.append(format);
        if (obfuscate) {
            builder.append("k\u00a7r ");
        }
        builder.append(source);
        if (obfuscate) {
            builder.append(" \u00a7kk");
        }
        builder.append("\u00a7r");
        return builder.toString();
    }

    public static String mergeRegister(String a, String b) {
        return a + "_" + b;
    }

    public static String swappedMergeRegister(String a, String b) {
        return TextHelper.mergeRegister(b, a);
    }

    public static void removeUnnecessaryEmptyLines(List<Component> components) {
        Reference<Object> reference = Reference.of(null);
        components.removeIf(component -> {
            Component value;
            if ((component.getString().equals("") || component == CommonComponents.f_237098_) && ((value = (Component)reference.getValue()) != null && value.getString().equals("") || value == CommonComponents.f_237098_)) {
                return true;
            }
            reference.setValue(component);
            return false;
        });
    }

    public static String createGiveFromStack(String targetSelector, ItemStack stack) {
        return "/give " + targetSelector + " " + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()) + stack.m_41784_();
    }

    public static MutableComponent wrapInObfuscation(MutableComponent source) {
        return Component.m_237113_((String)"\u00a7kA\u00a7r ").m_7220_((Component)source).m_130946_(" \u00a7kA\u00a7r");
    }

    public static String makeDescriptionId(Item item) {
        return Util.m_137492_((String)"item", (ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static String wrapInNameMarkers(String name) {
        return "'" + name + "'";
    }

    public static String wrapInRed(Object toWrap) {
        return TextHelper.wrapInFormatting(toWrap, ChatFormatting.RED);
    }

    public static void setHotbarDisplay(Player player, Component display) {
        player.m_5661_(display, true);
    }

    public static void sendSubTitle(Player player, Component subtitle) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        }
    }

    public static String getTextId(Item toGet) {
        return ForgeRegistries.ITEMS.getKey((Object)toGet).toString();
    }

    public static Item getFromId(String id) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
    }

    public static void clearTitle(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundClearTitlesPacket(true));
        }
    }

    public static int getMatchingAmount(String a, String b) {
        int i;
        for (i = 0; a.length() > i && b.length() > i && a.charAt(i) == b.charAt(i); ++i) {
        }
        return i;
    }

    public static String removeNumbers(String string) {
        for (String number : NUMBERS) {
            string = string.replace(number, "");
        }
        return string;
    }

    public static String createRandom(int length) {
        StringBuilder s = new StringBuilder();
        ArrayList<String> ALL_DEFAULT = new ArrayList<String>();
        ALL_DEFAULT.addAll(NUMBERS);
        ALL_DEFAULT.addAll(LETTERS_SMALL);
        ALL_DEFAULT.addAll(LETTERS_BIG);
        for (int i = 0; i < length; ++i) {
            s.append((String)MathHelper.pickRandom(ALL_DEFAULT));
        }
        return s.toString();
    }

    public static ChatFormatting damageIndicatorColorGenerator(String type) {
        return switch (type) {
            case "heal" -> ChatFormatting.GREEN;
            case "wither" -> ChatFormatting.BLACK;
            case "ferocity" -> ChatFormatting.GOLD;
            case "drown" -> ChatFormatting.AQUA;
            case "ability", "fire" -> ChatFormatting.DARK_RED;
            case "dodge" -> ChatFormatting.DARK_GRAY;
            default -> ChatFormatting.RED;
        };
    }

    @NotNull
    public static ChatFormatting damageIndicatorColorFromDouble(double in) {
        return TextHelper.damageIndicatorColorGenerator(TextHelper.damageIndicatorDecoder(in));
    }

    public static String damageIndicatorDecoder(double in) {
        return switch ((int)in) {
            case 1 -> "heal";
            case 2 -> "wither";
            case 3 -> "ferocity";
            case 4 -> "drown";
            case 5 -> "ability";
            case 6 -> "dodge";
            case 7 -> "fire";
            default -> "normal";
        };
    }

    public static int damageIndicatorCoder(String id) {
        return switch (id) {
            case "heal" -> 1;
            case "wither" -> 2;
            case "ferocity" -> 3;
            case "drown" -> 4;
            case "ability" -> 5;
            case "dodge" -> 6;
            case "fire" -> 7;
            default -> 0;
        };
    }

    public static String fromVec3(Vec3 vec3) {
        return "Pos: [" + vec3.f_82479_ + ", " + vec3.f_82480_ + ", " + vec3.f_82481_ + "]";
    }

    public static String fromBlockPos(BlockPos pos) {
        return TextHelper.fromVec3(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static <T, K> T makeList(List<K> toMerge, Supplier<T> generator, Function<K, T> transfer, BiConsumer<T, T> useConsumer) {
        T t = generator.get();
        for (K k : toMerge) {
            T transferred = transfer.apply(k);
            useConsumer.accept(t, transferred);
        }
        return t;
    }

    public static <T> String makeList(List<T> toMerge, Function<T, String> provider) {
        StringBuilder builder = new StringBuilder();
        for (T t : toMerge) {
            String s = provider.apply(t);
            builder.append(s);
            if (t == toMerge.get(toMerge.size() - 1)) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String makeGrammar(String toName) {
        String val1 = toName.replace("_", " ");
        char[] chars = val1.toCharArray();
        return TextHelper.fromStrings(TextHelper.makeCapital(TextHelper.fromChars(chars)));
    }

    private static String[] fromChars(char[] chars) {
        String[] strings = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            strings[i] = String.valueOf(chars[i]);
        }
        return strings;
    }

    private static String fromStrings(String[] strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
        }
        return builder.toString();
    }

    private static String[] makeCapital(String[] input) {
        boolean nextCapital = false;
        for (int i = 0; i < input.length; ++i) {
            if (Objects.equals(input[i], " ")) {
                nextCapital = true;
                continue;
            }
            if (!nextCapital && i != 0) continue;
            input[i] = input[i].toUpperCase();
            nextCapital = false;
        }
        if (nextCapital) {
            String[] toReturn = new String[input.length - 1];
            System.arraycopy(input, 0, toReturn, 0, toReturn.length);
            return toReturn;
        }
        return input;
    }

    public static Vec3 readVec3(StringReader pReader) throws CommandSyntaxException {
        pReader.expect('(');
        double x = pReader.readDouble();
        double y = pReader.readDouble();
        double z = pReader.readDouble();
        pReader.expect(')');
        return new Vec3(x, y, z);
    }
}

