/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.page.equipment;

import com.mojang.datafixers.util.Pair;
import net.kapitencraft.kap_lib.event.custom.WearableSlotChangeEvent;
import net.kapitencraft.kap_lib.inventory.menu.SlotAdder;
import net.kapitencraft.kap_lib.inventory.page.InventoryPage;
import net.kapitencraft.kap_lib.inventory.page.InventoryPageType;
import net.kapitencraft.kap_lib.inventory.wearable.IWearable;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaInventoryPages;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentPage
extends InventoryPage {
    private static final ItemStack SYMBOL = new ItemStack((ItemLike)Items.f_42473_);

    public EquipmentPage(final Player player, SlotAdder adder) {
        super((InventoryPageType)VanillaInventoryPages.EQUIPMENT.get());
        Wearables wearable = (Wearables)player.getCapability(Wearables.CAPABILITY).orElseThrow(() -> new IllegalStateException("unable to obtain player wearables!"));
        for (int i = 0; i < Wearables.SLOTS.length; ++i) {
            final WearableSlot slot = Wearables.SLOTS[i];
            adder.addSlot(new Slot(wearable, i, slot.getXPos(), slot.getYPos()){

                public void m_269060_(@NotNull ItemStack pStack) {
                    EquipmentPage.equip((LivingEntity)player, slot, pStack, this.m_7993_());
                    super.m_269060_(pStack);
                }

                public boolean m_5857_(@NotNull ItemStack pStack) {
                    IWearable wearable;
                    Item item = pStack.m_41720_();
                    return item instanceof IWearable && (wearable = (IWearable)item).getSlot() == slot;
                }

                public int m_6641_() {
                    return 1;
                }

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return slot.getNoItemIcon();
                }
            });
        }
    }

    public static void equip(LivingEntity living, WearableSlot slot, ItemStack newItem, ItemStack oldItem) {
        if (!(oldItem.m_41619_() && newItem.m_41619_() || ItemStack.m_150942_((ItemStack)oldItem, (ItemStack)newItem))) {
            IWearable wearable;
            Item item = newItem.m_41720_();
            if (item instanceof IWearable) {
                wearable = (IWearable)item;
                living.m_21204_().m_22178_(wearable.getModifiers(slot, newItem));
            }
            if ((item = oldItem.m_41720_()) instanceof IWearable) {
                wearable = (IWearable)item;
                living.m_21204_().m_22161_(wearable.getModifiers(slot, oldItem));
            }
            MinecraftForge.EVENT_BUS.post((Event)new WearableSlotChangeEvent(living, slot, oldItem, newItem));
        }
    }

    @Override
    @NotNull
    public ItemStack symbol() {
        return SYMBOL;
    }

    @Override
    public boolean withInventory() {
        return true;
    }
}

