/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.kapitencraft.kap_lib.io.serialization.DataPackSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.item.modifier_display.DisplayExtension;
import net.kapitencraft.kap_lib.item.modifier_display.EquipmentDisplayExtension;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeModifiersBonus
implements Bonus<AttributeModifiersBonus>,
EquipmentDisplayExtension {
    private static final Codec<Multimap<Attribute, AttributeModifier>> ENTRIES_CODEC = Codec.unboundedMap((Codec)ForgeRegistries.ATTRIBUTES.getCodec(), (Codec)ExtraCodecs.ATTRIBUTE_MODIFIER.listOf()).xmap(CollectionHelper::fromListMap, CollectionHelper::fromMultimap);
    private static final Codec<AttributeModifiersBonus> CODEC = RecordCodecBuilder.create(attributeModifiersBonusInstance -> attributeModifiersBonusInstance.group((App)ENTRIES_CODEC.fieldOf("entries").forGetter(AttributeModifiersBonus::getModifiers), (App)DisplayExtension.Type.CODEC.optionalFieldOf("bracket_type", (Object)DisplayExtension.Type.NONE).forGetter(AttributeModifiersBonus::getType), (App)ExtraCodecs.EFFECT_SERIALIZING_STYLE.optionalFieldOf("style", (Object)Style.f_131099_).forGetter(AttributeModifiersBonus::getStyle)).apply((Applicative)attributeModifiersBonusInstance, AttributeModifiersBonus::new));
    public static final DataPackSerializer<AttributeModifiersBonus> SERIALIZER = new DataPackSerializer<AttributeModifiersBonus>(CODEC, AttributeModifiersBonus::fromNetwork, AttributeModifiersBonus::toNetwork);
    private final Multimap<Attribute, AttributeModifier> modifiers;
    private final DisplayExtension.Type type;
    private final Style style;

    public AttributeModifiersBonus(Multimap<Attribute, AttributeModifier> modifiers, DisplayExtension.Type type, Style style) {
        this.modifiers = modifiers;
        this.type = type;
        this.style = style;
    }

    private Multimap<Attribute, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    @NotNull
    public Multimap<Attribute, AttributeModifier> getModifiers(EquipmentSlot slot) {
        return this.modifiers;
    }

    @Override
    public DataPackSerializer<AttributeModifiersBonus> getSerializer() {
        return SERIALIZER;
    }

    @Override
    @Nullable
    public Multimap<Attribute, AttributeModifier> getModifiers(LivingEntity living) {
        return this.modifiers;
    }

    private static AttributeModifiersBonus fromNetwork(FriendlyByteBuf buf) {
        return new AttributeModifiersBonus(NetworkHelper.readMultimap(buf, buf1 -> (Attribute)buf1.readRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES), buf1 -> (AttributeModifier)buf1.m_271872_(ExtraCodecs.ATTRIBUTE_MODIFIER)), (DisplayExtension.Type)buf.m_130066_(DisplayExtension.Type.class), (Style)buf.m_271872_(ExtraCodecs.EFFECT_SERIALIZING_STYLE));
    }

    private static void toNetwork(FriendlyByteBuf buf, AttributeModifiersBonus bonus) {
        NetworkHelper.writeMultimap(buf, bonus.modifiers, (buf1, attribute) -> buf1.writeRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES, attribute), (buf1, modifier) -> buf1.m_272073_(ExtraCodecs.ATTRIBUTE_MODIFIER, modifier));
        buf.m_130068_((Enum)bonus.type);
        buf.m_272073_(ExtraCodecs.EFFECT_SERIALIZING_STYLE, (Object)bonus.style);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public DisplayExtension.Type getType() {
        return this.type;
    }

    public static class Builder {
        private final Multimap<Attribute, AttributeModifier> modifiers = HashMultimap.create();
        private DisplayExtension.Type type = DisplayExtension.Type.NONE;
        private Style style = Style.f_131099_;

        public Builder addModifier(Attribute attribute, AttributeModifier modifier) {
            this.modifiers.put((Object)attribute, (Object)modifier);
            return this;
        }

        public Builder addModifier(Supplier<? extends Attribute> supplier, AttributeModifier modifier) {
            return this.addModifier(supplier.get(), modifier);
        }

        public Builder addModifier(Attribute attribute, String name, double amount, AttributeModifier.Operation operation) {
            return this.addModifier(attribute, new AttributeModifier(UUID.randomUUID(), name, amount, operation));
        }

        public Builder addModifier(Supplier<? extends Attribute> supplier, String name, double amount, AttributeModifier.Operation operation) {
            return this.addModifier(supplier.get(), name, amount, operation);
        }

        public Builder setBracketType(DisplayExtension.Type type) {
            this.type = type;
            return this;
        }

        public Builder setDisplayStyle(UnaryOperator<Style> style) {
            this.style = (Style)style.apply(Style.f_131099_);
            return this;
        }

        public AttributeModifiersBonus build() {
            return new AttributeModifiersBonus((Multimap<Attribute, AttributeModifier>)ImmutableMultimap.copyOf(this.modifiers), this.type, this.style);
        }
    }
}

