/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.io.serialization.DataPackSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EffectsBonus
implements Bonus<EffectsBonus> {
    private static final Codec<MobEffectInstance> EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::m_19564_)).apply((Applicative)instance, MobEffectInstance::new));
    private static final Codec<EffectsBonus> CODEC = EFFECT_INSTANCE_CODEC.listOf().xmap(EffectsBonus::new, EffectsBonus::getEffects);
    public static final DataPackSerializer<EffectsBonus> SERIALIZER = new DataPackSerializer<EffectsBonus>(CODEC, EffectsBonus::fromNetwork, EffectsBonus::toNetwork);
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

    public EffectsBonus(List<MobEffectInstance> effects) {
        this.effects.addAll(effects);
    }

    private List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    @Override
    public DataPackSerializer<EffectsBonus> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public void onTick(int tickCount, @NotNull LivingEntity entity) {
        this.effects.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)entity).m_7292_(arg_0));
    }

    @Override
    public boolean isEffectTick(int tickCount, LivingEntity living) {
        return true;
    }

    private static void writeEffect(FriendlyByteBuf buf, MobEffectInstance instance) {
        buf.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)instance.m_19544_());
        buf.writeInt(instance.m_19557_());
        buf.writeInt(instance.m_19564_());
    }

    public static EffectsBonus fromNetwork(FriendlyByteBuf buf) {
        return new EffectsBonus((List)buf.m_236838_(ArrayList::new, EffectsBonus::readEffect));
    }

    private static void toNetwork(FriendlyByteBuf buf, EffectsBonus bonus) {
        buf.m_236828_(bonus.effects, EffectsBonus::writeEffect);
    }

    private static MobEffectInstance readEffect(FriendlyByteBuf buf) {
        MobEffect effect = (MobEffect)buf.readRegistryId();
        int duration = buf.readInt();
        int amplifier = buf.readInt();
        return new MobEffectInstance(effect, duration, amplifier);
    }
}

