/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.kapitencraft.kap_lib.client.font.effect.EffectsStyle;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.mixin.duck.IKapLibComponentContents;
import net.kapitencraft.kap_lib.mixin.duck.IKapLibDataSource;
import net.kapitencraft.kap_lib.mixin.duck.attribute.IKapLibAttributeModifier;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public interface ExtraCodecs {
    public static final Codec<ComponentContents> COMPONENT_TYPES = ExtraRegistries.COMPONENT_CONTENT_TYPES.getCodec().dispatchStable(IKapLibComponentContents::codecFromVanilla, Function.identity());
    public static final Codec<Component> COMPONENT = COMPONENT_TYPES.xmap(MutableComponent::m_237204_, Component::m_214077_);
    public static final Codec<Object[]> TRANSLATABLE_COMPONENT_ARGS = COMPONENT.listOf().xmap(list -> {
        Object[] array = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = Component.Serializer.m_237120_(list.get(i));
        }
        return array;
    }, objects -> {
        ArrayList<Object> components = new ArrayList<Object>();
        for (Object o : objects) {
            if (o instanceof Component) {
                Component c = (Component)o;
                components.add(c);
                continue;
            }
            components.add(Component.m_237113_((String)o.toString()));
        }
        return components;
    });
    public static final Codec<DataSource> DATA_SOURCE = ExtraRegistries.DATA_SOURCE_TYPES.getCodec().dispatchStable(IKapLibDataSource::codecFromVanilla, Function.identity());
    public static final Codec<AttributeModifier> ATTRIBUTE_MODIFIER = ExtraRegistries.ATTRIBUTE_MODIFIER_TYPES.getCodec().dispatchStable(IKapLibAttributeModifier::codecFromVanilla, Function.identity());
    public static final Codec<Style> EFFECT_SERIALIZING_STYLE = RecordCodecBuilder.create(styleInstance -> styleInstance.group((App)TextColor.f_237295_.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.f_131101_)), (App)Codec.BOOL.optionalFieldOf("bold", (Object)false).forGetter(Style::m_131154_), (App)Codec.BOOL.optionalFieldOf("italic", (Object)false).forGetter(Style::m_131161_), (App)Codec.BOOL.optionalFieldOf("underlined", (Object)false).forGetter(Style::m_131171_), (App)Codec.BOOL.optionalFieldOf("strikethrough", (Object)false).forGetter(Style::m_131168_), (App)Codec.BOOL.optionalFieldOf("obfuscated", (Object)false).forGetter(Style::m_131176_), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(p_237269_ -> Optional.ofNullable(p_237269_.m_131189_())), (App)ResourceLocation.f_135803_.optionalFieldOf("font", (Object)Style.f_131100_).forGetter(Style::m_131192_), (App)ExtraRegistries.GLYPH_EFFECTS.getCodec().listOf().optionalFieldOf("effects", List.of()).forGetter(style -> List.of(EffectsStyle.of(style).getEffects()))).apply((Applicative)styleInstance, ExtraCodecs::createStyleFromCodec));
    @Deprecated(forRemoval=true, since="1.26.4")
    public static final Codec<UUID> UUID = UUIDUtil.f_260719_;
    public static final Codec<MobEffectInstance> EFFECT = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(MobEffectInstance::m_19572_)).apply((Applicative)instance, MobEffectInstance::new));
    public static final Codec<Bonus<?>> BONUS = ExtraRegistries.BONUS_SERIALIZER.getCodec().dispatchStable(Bonus::getSerializer, s -> s.getCodec().fieldOf("data").codec());

    public static Style createStyleFromCodec(Optional<TextColor> color, Boolean bold, Boolean italic, Boolean underlined, Boolean strikethrough, Boolean obfuscated, Optional<String> insertion, ResourceLocation font, List<GlyphEffect> effects) {
        Style style = new Style((TextColor)color.orElse(null), bold, italic, underlined, strikethrough, obfuscated, null, null, (String)insertion.orElse(null), font);
        EffectsStyle.of(style).setEffects((GlyphEffect[])effects.toArray(GlyphEffect[]::new));
        return style;
    }
}

