/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.event.custom.RegisterRequirementTypesEvent;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RequirementManager
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static RequirementManager instance;
    private final Map<String, Element<?>> elements = new HashMap();
    private final List<RequirementType<?>> types = new ArrayList();
    private Map<String, RequirementType<?>> typesForNames;

    public RequirementManager() {
        super(JsonHelper.GSON, "requirements");
        this.registerTypes();
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        MapStream.of(pObject).mapKeys(ResourceLocation::m_135815_).mapKeys(s -> s.replace(".json", "")).mapKeys(this.typesForNames::get).forEach(this::readElement);
    }

    private <T> void readElement(RequirementType<T> type, JsonElement jsonElement) {
        this.elements.values().stream().filter(element -> element.isType(type)).findFirst().ifPresentOrElse(element -> element.read(jsonElement), () -> {
            Element element = new Element(type);
            element.read(jsonElement);
            this.elements.put(type.getName(), element);
        });
    }

    public <T> Collection<ReqCondition<?>> getReqs(RequirementType<T> type, T t) {
        Element<?> element = this.elements.get(type.getName());
        return element != null ? element.requirements.get(t) : List.of();
    }

    public <T> boolean meetsRequirements(RequirementType<T> type, @Nullable T value, LivingEntity living) {
        return living != null && this.getReqs(type, value).stream().allMatch(reqCondition -> reqCondition.matches(living));
    }

    public static boolean meetsItemRequirementsFromEvent(LivingEvent event, EquipmentSlot slot) {
        return instance != null && instance.meetsRequirements(RegistryReqType.ITEM, event.getEntity().m_6844_(slot).m_41720_(), event.getEntity());
    }

    private void registerTypes() {
        this.types.add(RequirementType.ITEM);
        this.types.add(RequirementType.ENCHANTMENT);
        this.types.add(RequirementType.BONUS);
        MinecraftForge.EVENT_BUS.post((Event)new RegisterRequirementTypesEvent(this.types::add));
        this.typesForNames = this.types.stream().collect(CollectorHelper.createMapForKeys(RequirementType::getName));
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_236831_(this.elements, FriendlyByteBuf::m_130070_, (buf1, element) -> element.toNetwork((FriendlyByteBuf)buf1));
    }

    public void readFromNetwork(FriendlyByteBuf buf) {
        this.elements.putAll(buf.m_236847_(FriendlyByteBuf::m_130277_, this::fromNetwork));
    }

    private <T> Element<T> fromNetwork(FriendlyByteBuf buf) {
        RequirementType<?> type = this.typesForNames.get(buf.m_130277_());
        Element element = new Element(type);
        Map map = buf.m_236847_(buf1 -> type.getById(buf1.m_130281_()), buf1 -> buf1.m_236845_(ReqCondition::fromNetwork));
        map.forEach((t, reqConditions) -> reqConditions.forEach(reqCondition -> element.addElement(t, (ReqCondition<?>)reqCondition)));
        return element;
    }

    private static class Element<T> {
        private final RequirementType<T> type;
        private final Multimap<T, ReqCondition<?>> requirements = HashMultimap.create();

        private Element(RequirementType<T> type) {
            this.type = type;
        }

        public boolean isType(RequirementType<?> type) {
            return type == this.type;
        }

        public void read(JsonElement jsonElement) {
            try {
                JsonObject object = jsonElement.getAsJsonObject();
                MapStream.of(object.asMap()).mapKeys(ResourceLocation::new).mapKeys(this.type::getById).filterKeys(Objects::nonNull).mapValues(JsonElement::getAsJsonObject).mapValues(ReqCondition::readFromJson).forEach(this::addElement);
            }
            catch (Exception e) {
                LOGGER.warn(Markers.REQUIREMENTS_MANAGER, "error loading requirements for type '{}': {}", (Object)this.type.getName(), (Object)e.getMessage());
            }
        }

        private void addElement(T value, ReqCondition<?> condition) {
            if (condition != null) {
                this.requirements.put(value, condition);
            }
        }

        private void toNetwork(FriendlyByteBuf buf) {
            buf.m_130070_(this.type.getName());
            buf.m_236831_(this.requirements.asMap(), (buf1, t) -> buf1.m_130085_(this.type.getId(t)), (buf1, reqConditions) -> buf1.m_236828_(reqConditions, (byteBuf, reqCondition) -> reqCondition.toNetwork((FriendlyByteBuf)byteBuf)));
        }
    }
}

