/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.CompositeEntryBase;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SequentialEntry
extends CompositeEntryBase {
    public SequentialEntry(SpawnPoolEntryContainer[] pChildren, LootItemCondition[] pConditions) {
        super(pChildren, pConditions);
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.SEQUENCE.get());
    }

    @Override
    protected ComposableEntryContainer compose(ComposableEntryContainer[] pEntries) {
        switch (pEntries.length) {
            case 0: {
                return ALWAYS_TRUE;
            }
            case 1: {
                return pEntries[0];
            }
            case 2: {
                return pEntries[0].and(pEntries[1]);
            }
        }
        return (p_79819_, p_79820_) -> {
            for (ComposableEntryContainer composableentrycontainer : pEntries) {
                if (composableentrycontainer.expand(p_79819_, p_79820_)) continue;
                return false;
            }
            return true;
        };
    }

    public static Builder sequential(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
        return new Builder(pChildren);
    }

    public static class Builder
    extends SpawnPoolEntryContainer.Builder<Builder> {
        private final List<SpawnPoolEntryContainer> entries = Lists.newArrayList();

        public Builder(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
            for (SpawnPoolEntryContainer.Builder<?> builder : pChildren) {
                this.entries.add(builder.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder then(SpawnPoolEntryContainer.Builder<?> pChildBuilder) {
            this.entries.add(pChildBuilder.build());
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return new SequentialEntry(this.entries.toArray(new SpawnPoolEntryContainer[0]), this.getConditions());
        }
    }
}

