/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolSingletonContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.AddEffectsFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnEffectCloud
extends SpawnPoolSingletonContainer {
    private final Potion potion;
    private final MobEffectInstance[] effects;
    private final int duration;
    private final int durationOnUse;
    private final int waitTime;
    private final Integer color;
    private final float radius;
    private final float radiusOnUse;
    private final float radiusPerTick;
    private final LootContext.EntityTarget owner;

    protected SpawnEffectCloud(int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions, Potion potion, MobEffectInstance[] effects, float radius, float radiusOnUse, float radiusPerTick, int duration, int durationOnUse, Integer color, int waitTime, LootContext.EntityTarget owner) {
        super(pWeight, pQuality, pConditions, pFunctions);
        this.potion = potion;
        this.effects = effects;
        this.duration = duration;
        this.radius = radius;
        this.radiusOnUse = radiusOnUse;
        this.radiusPerTick = radiusPerTick;
        this.durationOnUse = durationOnUse;
        this.color = color;
        this.waitTime = waitTime;
        this.owner = owner;
    }

    @Override
    protected void createEntity(Consumer<Entity> pEntityConsumer, SpawnContext pLootContext) {
        AreaEffectCloud cloud = (AreaEffectCloud)EntityType.f_20476_.m_20615_((Level)pLootContext.m_78952_());
        if (cloud == null) {
            KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "unable to create effect cloud!");
            return;
        }
        if (this.potion != null) {
            cloud.m_19722_(this.potion);
        } else if (this.effects != null) {
            for (MobEffectInstance effect : this.effects) {
                cloud.m_19716_(effect);
            }
        }
        cloud.m_19712_(this.radius);
        cloud.m_19732_(this.radiusOnUse);
        cloud.m_19738_(this.radiusPerTick);
        cloud.m_19734_(this.duration);
        cloud.m_146785_(this.durationOnUse);
        cloud.m_19740_(this.waitTime);
        if (this.color != null) {
            cloud.m_19714_(this.color.intValue());
        }
        if (this.owner != null) {
            Object object = pLootContext.m_165124_(this.owner.m_79003_());
            if (object instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)object;
                cloud.m_19718_(living);
            } else {
                KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "owner {} was no living entity", pLootContext.m_165124_(this.owner.m_79003_()));
            }
        }
        pEntityConsumer.accept((Entity)cloud);
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.EFFECT_CLOUD.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnPoolSingletonContainer.Builder<Builder> {
        private Potion potion;
        private MobEffectInstance[] effects;
        private float radius = 3.0f;
        private float radiusOnUse = -0.5f;
        private float radiusPerTick = -0.005f;
        private int duration = 600;
        private int durationOnUse;
        private Integer color;
        private int waitTime = 20;
        private LootContext.EntityTarget owner;

        public Builder setOwner(LootContext.EntityTarget target) {
            this.owner = target;
            return this;
        }

        public Builder setPotion(Potion potion) {
            this.potion = potion;
            return this;
        }

        public Builder setEffects(MobEffectInstance ... effects) {
            this.effects = effects;
            return this;
        }

        public Builder setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder setRadiusOnUse(float radiusOnUse) {
            this.radiusOnUse = radiusOnUse;
            return this;
        }

        public Builder setRadiusPerTick(float radiusPerTick) {
            this.radiusPerTick = radiusPerTick;
            return this;
        }

        public Builder setDuration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder setDurationOnUse(int durationOnUse) {
            this.durationOnUse = durationOnUse;
            return this;
        }

        public Builder setColor(int color) {
            this.color = color;
            return this;
        }

        public Builder setColor(Color color) {
            return this.setColor(color.pack());
        }

        public Builder setWaitTime(int waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return new SpawnEffectCloud(this.weight, this.quality, this.getConditions(), this.getFunctions(), this.potion, this.effects, this.radius, this.radiusOnUse, this.radiusPerTick, this.duration, this.durationOnUse, this.color, this.waitTime, this.owner);
        }
    }

    public static class Serializer
    extends SpawnPoolSingletonContainer.Serializer<SpawnEffectCloud> {
        @Override
        public void serializeCustom(JsonObject pObject, SpawnEffectCloud pContainer, JsonSerializationContext pConditions) {
            super.serializeCustom(pObject, pContainer, pConditions);
            if (pContainer.potion != null) {
                pObject.addProperty("potion", Objects.requireNonNull(ForgeRegistries.POTIONS.getKey((Object)pContainer.potion), "unknown potion: " + pContainer.potion.m_43492_("")).toString());
            }
            if (pContainer.effects != null) {
                pObject.add("effects", (JsonElement)AddEffectsFunction.EFFECT_SERIALIZER.encode(List.of(pContainer.effects)));
            }
            if (pContainer.duration != 600) {
                pObject.addProperty("duration", (Number)pContainer.duration);
            }
            if (pContainer.radius != 3.0f) {
                pObject.addProperty("radius", (Number)Float.valueOf(pContainer.radius));
            }
            if (pContainer.radiusOnUse != -0.5f) {
                pObject.addProperty("radiusOnUse", (Number)Float.valueOf(pContainer.radiusOnUse));
            }
            if (pContainer.radiusPerTick != -pContainer.radius / (float)pContainer.duration) {
                pObject.addProperty("radiusPerTick", (Number)Float.valueOf(pContainer.radiusPerTick));
            }
            pObject.addProperty("durationOnUse", (Number)pContainer.durationOnUse);
            if (pContainer.color != null) {
                pObject.addProperty("color", (Number)pContainer.color);
            }
            if (pContainer.waitTime != 20) {
                pObject.addProperty("waitTime", (Number)pContainer.waitTime);
            }
            if (pContainer.owner != null) {
                pObject.add("owner", pConditions.serialize((Object)pContainer.owner));
            }
        }

        @Override
        protected SpawnEffectCloud deserialize(JsonObject pObject, JsonDeserializationContext pContext, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
            Potion potion = pObject.has("potion") ? Potion.m_43489_((String)GsonHelper.m_13906_((JsonObject)pObject, (String)"potion")) : null;
            MobEffectInstance[] effects = pObject.has("effects") ? (MobEffectInstance[])((List)AddEffectsFunction.EFFECT_SERIALIZER.parse((List<MobEffectInstance>)pObject.get("effects"))).toArray(MobEffectInstance[]::new) : null;
            int duration = GsonHelper.m_13824_((JsonObject)pObject, (String)"duration", (int)600);
            float radius = GsonHelper.m_13820_((JsonObject)pObject, (String)"radius", (float)3.0f);
            float radiusOnUse = GsonHelper.m_13820_((JsonObject)pObject, (String)"radiusOnUse", (float)-0.5f);
            float radiusPerTick = GsonHelper.m_13820_((JsonObject)pObject, (String)"radiusPerTick", (float)(-radius / (float)duration));
            int durationOnUse = GsonHelper.m_13927_((JsonObject)pObject, (String)"durationOnUse");
            Integer color = pObject.has("color") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)pObject, (String)"color")) : null;
            int waitTime = GsonHelper.m_13824_((JsonObject)pObject, (String)"waitTime", (int)20);
            LootContext.EntityTarget owner = pObject.has("owner") ? (LootContext.EntityTarget)pContext.deserialize(pObject.get("owner"), LootContext.EntityTarget.class) : null;
            return new SpawnEffectCloud(pWeight, pQuality, pConditions, pFunctions, potion, effects, radius, radiusOnUse, radiusPerTick, duration, durationOnUse, color, waitTime, owner);
        }
    }
}

