/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.stream.Collectors;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetMerchantTradesFunction
extends SpawnEntityConditionalFunction {
    private final MerchantOffers offers;

    protected SetMerchantTradesFunction(LootItemCondition[] pPredicates, MerchantOffers offers) {
        super(pPredicates);
        this.offers = offers;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof AbstractVillager) {
            AbstractVillager abstractVillager = (AbstractVillager)pEntity;
            MerchantOffers offers = abstractVillager.m_6616_();
            offers.clear();
            offers.addAll((Collection)this.offers);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return (SpawnEntityFunctionType)((Object)SpawnEntityFunctions.SET_MERCHANT_TRADES.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private final MerchantOffers offers = new MerchantOffers();

        public Builder addOffer(MerchantOffer offer) {
            this.offers.add((Object)offer);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new SetMerchantTradesFunction(this.getConditions(), this.offers);
        }
    }

    public static class Serializer
    extends SpawnEntityConditionalFunction.Serializer<SetMerchantTradesFunction> {
        @Override
        public void serialize(JsonObject pJson, SetMerchantTradesFunction pFunction, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pFunction, pSerializationContext);
            JsonArray array = pFunction.offers.stream().map(Serializer::writeOffer).collect(CollectorHelper.toJsonArray());
            pJson.add("offers", (JsonElement)array);
        }

        private static JsonObject writeOffer(MerchantOffer offer) {
            JsonObject object = new JsonObject();
            JsonHelper.addItemStack(object, "costA", offer.m_45352_());
            if (offer.m_45364_() != ItemStack.f_41583_) {
                JsonHelper.addItemStack(object, "costB", offer.m_45364_());
            }
            JsonHelper.addItemStack(object, "result", offer.m_45368_());
            if (offer.m_45371_() != 0) {
                object.addProperty("uses", (Number)offer.m_45371_());
            }
            object.addProperty("maxUses", (Number)offer.m_45373_());
            if (!offer.m_45383_()) {
                object.addProperty("rewardXp", Boolean.valueOf(false));
            }
            if (offer.m_45377_() != 0) {
                object.addProperty("specialPriceDiff", (Number)offer.m_45377_());
            }
            if (offer.m_45375_() != 0) {
                object.addProperty("demand", (Number)offer.m_45375_());
            }
            if (offer.m_45378_() != 1.0f) {
                object.addProperty("priceMultiplier", (Number)Float.valueOf(offer.m_45378_()));
            }
            if (offer.m_45379_() != 1) {
                object.addProperty("xp", (Number)offer.m_45379_());
            }
            return object;
        }

        @Override
        public SetMerchantTradesFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            MerchantOffers offers = JsonHelper.castToObjects(GsonHelper.m_13933_((JsonObject)pObject, (String)"offers")).map(Serializer::readOffer).collect(Collectors.toCollection(MerchantOffers::new));
            return new SetMerchantTradesFunction(pConditions, offers);
        }

        private static MerchantOffer readOffer(JsonObject object) {
            ItemStack costA = JsonHelper.getAsItemStack(GsonHelper.m_13930_((JsonObject)object, (String)"costA"));
            ItemStack costB = object.has("costB") ? JsonHelper.getAsItemStack(GsonHelper.m_13930_((JsonObject)object, (String)"costB")) : ItemStack.f_41583_;
            ItemStack result = JsonHelper.getAsItemStack(GsonHelper.m_13930_((JsonObject)object, (String)"result"));
            int uses = GsonHelper.m_13824_((JsonObject)object, (String)"uses", (int)0);
            int maxUses = GsonHelper.m_13927_((JsonObject)object, (String)"maxUses");
            boolean rewardXp = GsonHelper.m_13855_((JsonObject)object, (String)"rewardXp", (boolean)true);
            int specialPriceDiff = GsonHelper.m_13824_((JsonObject)object, (String)"specialPriceDiff", (int)0);
            int demand = GsonHelper.m_13824_((JsonObject)object, (String)"demand", (int)0);
            float priceMultiplier = GsonHelper.m_13824_((JsonObject)object, (String)"priceMultiplier", (int)1);
            int xp = GsonHelper.m_13824_((JsonObject)object, (String)"xp", (int)1);
            MerchantOffer offer = new MerchantOffer(costA, costB, result, uses, maxUses, xp, priceMultiplier, demand);
            offer.f_45315_ = rewardXp;
            offer.m_45359_(specialPriceDiff);
            return offer;
        }
    }
}

