/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import java.util.List;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector2i;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@ApiStatus.Internal
public class ScrollableTooltips {
    private static int scrollY = 0;
    private static int initY = 0;
    private static float scale = 1.0f;
    private static boolean allowScroll;
    private static int oldTooltipSize;
    private static Slot active;

    @SubscribeEvent
    public static void onRenderForeground(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen.f_97734_ != active) {
            scrollY = 0;
            active = screen.f_97734_;
        }
    }

    @SubscribeEvent
    public static void registerScrollable(RenderTooltipEvent.Pre event) {
        int i;
        Vector2i toolTipSize = ScrollableTooltips.createToolTipBoxSize(event.getComponents(), event.getFont());
        Vector2i screenSize = new Vector2i(event.getScreenWidth(), event.getScreenHeight());
        Vector2i pos = new Vector2i(event.getX(), event.getY());
        int height = event.getY();
        allowScroll = toolTipSize.y > screenSize.y;
        boolean isHigherThanScreen = allowScroll;
        if (!(scrollY != 0 && isHigherThanScreen || pos.y + (i = toolTipSize.y + 3) <= screenSize.y)) {
            height = screenSize.y - i;
        }
        if (isHigherThanScreen) {
            if (oldTooltipSize != toolTipSize.y && oldTooltipSize != 0) {
                scrollY *= (int)((double)toolTipSize.y / (double)oldTooltipSize);
                oldTooltipSize = toolTipSize.y;
            }
            if (scrollY == 0) {
                initY = height;
            }
            event.setY(initY + scrollY);
            return;
        }
        event.setY(height);
    }

    @SubscribeEvent
    public static void scrollEvent(ScreenEvent.MouseScrolled.Pre event) {
        if (active != null && active.m_6657_() && allowScroll) {
            event.setCanceled(true);
            float scrollDelta = (float)event.getScrollDelta();
            int scrollOffset = Mth.m_14107_((double)((double)scrollDelta * ClientModConfig.getScrollScale()));
            if (Screen.m_96637_()) {
                scale += (float)scrollOffset;
            } else {
                scrollY -= scrollOffset;
            }
        }
    }

    private static Vector2i createToolTipBoxSize(List<ClientTooltipComponent> components, Font font) {
        int i = 0;
        int j = 0;
        for (ClientTooltipComponent clienttooltipcomponent : components) {
            int k = clienttooltipcomponent.m_142069_(font);
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.m_142103_();
        }
        return new Vector2i(i, j);
    }

    static {
        oldTooltipSize = 0;
    }
}

